/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.nashorn_modules;

import com.coveo.nashorn_modules.AbstractFolder;
import com.coveo.nashorn_modules.Folder;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class ResourceFolder
extends AbstractFolder {
    private ClassLoader loader;
    private String resourcePath;
    private String encoding;

    @Override
    public String getFile(String name) {
        InputStream stream = this.loader.getResourceAsStream(this.resourcePath + "/" + name);
        if (stream == null) {
            return null;
        }
        try {
            return IOUtils.toString((InputStream)stream, (String)this.encoding);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Folder getFolder(String name) {
        return new ResourceFolder(this.loader, this.resourcePath + "/" + name, this, this.getPath() + name + "/", this.encoding);
    }

    private ResourceFolder(ClassLoader loader, String resourcePath, Folder parent, String displayPath, String encoding) {
        super(parent, displayPath);
        this.loader = loader;
        this.resourcePath = resourcePath;
        this.encoding = encoding;
    }

    public static ResourceFolder create(ClassLoader loader, String path, String encoding) {
        return new ResourceFolder(loader, path, null, "/", encoding);
    }
}

