/*
 * Decompiled with CFR 0.152.
 */
package com.coveo;

import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFMT
extends AbstractMojo {
    private Log logger = this.getLog();
    private Formatter formatter = new Formatter();
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDirectory", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", property="testSourceDirectory", required=true)
    private File testSourceDirectory;
    @Parameter(property="additionalSourceDirectories")
    private File[] additionalSourceDirectories;
    @Parameter(defaultValue="false", property="verbose")
    private boolean verbose;
    @Parameter(defaultValue="false", property="failOnUnknownFolder")
    private boolean failOnUnknownFolder;
    @Parameter(defaultValue=".*\\.java", property="filesNamePattern")
    private String filesNamePattern;
    private List<String> filesFormatted = new ArrayList<String>();
    private int nonComplyingFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<File> directoriesToFormat = new ArrayList<File>();
        if (this.sourceDirectory.exists()) {
            directoriesToFormat.add(this.sourceDirectory);
        } else {
            this.handleMissingDirectory("Source", this.sourceDirectory);
        }
        if (this.testSourceDirectory.exists()) {
            directoriesToFormat.add(this.testSourceDirectory);
        } else {
            this.handleMissingDirectory("Test source", this.testSourceDirectory);
        }
        for (File additionalSourceDirectory : this.additionalSourceDirectories) {
            if (additionalSourceDirectory.exists()) {
                directoriesToFormat.add(additionalSourceDirectory);
                continue;
            }
            this.handleMissingDirectory("Additional source", additionalSourceDirectory);
        }
        for (File directoryToFormat : directoriesToFormat) {
            this.formatSourceFilesInDirectory(directoryToFormat);
        }
        this.maybeFailIfNonComplying();
        this.logNumberOfFilesFormatted();
    }

    public List<String> getFilesFormatted() {
        return this.filesFormatted;
    }

    protected abstract boolean isValidateOnly();

    private void formatSourceFilesInDirectory(File directory) {
        if (!directory.isDirectory()) {
            this.logger.info((CharSequence)("Directory '" + directory + "' is not a directory. Skipping."));
            return;
        }
        List<File> files = Arrays.asList(directory.listFiles(this.getFileFilter()));
        for (File file : files) {
            if (file.isDirectory()) {
                this.formatSourceFilesInDirectory(file);
                continue;
            }
            this.formatSourceFile(file);
        }
    }

    private FileFilter getFileFilter() {
        if (this.verbose) {
            this.logger.debug((CharSequence)("Filter files on '" + this.filesNamePattern + "'."));
        }
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().matches(AbstractFMT.this.filesNamePattern);
            }
        };
    }

    private void formatSourceFile(File file) {
        if (file.isDirectory()) {
            this.logger.info((CharSequence)("File '" + file + "' is a directory. Skipping."));
            return;
        }
        if (this.verbose) {
            this.logger.debug((CharSequence)("Formatting '" + file + "'."));
        }
        CharSource source = Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
        CharSink sink = Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
        try {
            String input = source.read();
            String formatted = this.formatter.formatSource(input);
            formatted = RemoveUnusedImports.removeUnusedImports((String)formatted, (RemoveUnusedImports.JavadocOnlyImports)RemoveUnusedImports.JavadocOnlyImports.KEEP);
            formatted = ImportOrderer.reorderImports((String)formatted);
            if (!input.equals(formatted)) {
                if (!this.isValidateOnly()) {
                    sink.write((CharSequence)formatted);
                }
                ++this.nonComplyingFiles;
            }
            this.filesFormatted.add(file.getAbsolutePath());
            if (this.filesFormatted.size() % 100 == 0) {
                this.logNumberOfFilesFormatted();
            }
        }
        catch (FormatterException e) {
            this.logger.warn((CharSequence)("Failed to format file '" + file + "'."), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn((CharSequence)("Failed to format file '" + file + "'."), (Throwable)e);
        }
    }

    private void handleMissingDirectory(String directoryDisplayName, File directory) throws MojoFailureException {
        if (this.failOnUnknownFolder) {
            String message = directoryDisplayName + " directory '" + directory + "' does not exist, failing build (failOnUnknownFolder is true).";
            this.logger.error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        this.logger.warn((CharSequence)(directoryDisplayName + " directory '" + directory + "' does not exist, ignoring."));
    }

    private void logNumberOfFilesFormatted() {
        this.logger.info((CharSequence)String.format("Processed %d files (%d %s).", this.filesFormatted.size(), this.nonComplyingFiles, this.isValidateOnly() ? "non-complying" : "reformatted"));
    }

    private void maybeFailIfNonComplying() throws MojoFailureException {
        if (this.isValidateOnly() && this.nonComplyingFiles > 0) {
            String message = "Found " + this.nonComplyingFiles + " non-complying files, failing build (validateOnly is true)";
            this.logger.error((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }
}

