/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.system.ErrnoException;
import com.couchbase.lite.internal.replicator.AbstractCBLWebSocket;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.utils.Fn;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateRevokedException;
import java.util.List;

public class CBLWebSocket
extends AbstractCBLWebSocket {
    public CBLWebSocket(long peer, @NonNull URI uri, @Nullable byte[] opts, @NonNull CBLCookieStore cookieStore, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) throws GeneralSecurityException {
        super(peer, uri, opts, cookieStore, serverCertsListener);
    }

    @Override
    protected boolean handleClose(@NonNull Throwable error) {
        for (Throwable cause = error; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ErrnoException)) continue;
            this.closed(2, ((ErrnoException)cause).errno, error.toString());
            return true;
        }
        return false;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected int handleCloseCause(@NonNull Throwable cause) {
        return Build.VERSION.SDK_INT < 24 ? 0 : this.handleCloseCausePostAPI23(cause);
    }

    @RequiresApi(api=24)
    private int handleCloseCausePostAPI23(Throwable cause) {
        return !(cause instanceof CertificateRevokedException) ? 0 : 7;
    }
}

