/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import android.support.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.replicator.NetworkConnectivityManager;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Fn;

public class AndroidConnectivityObserver
implements NetworkConnectivityManager.Observer {
    @NonNull
    private final NetworkConnectivityManager connectivityManager;
    @NonNull
    private final Fn.Provider<C4Replicator> replFactory;

    public AndroidConnectivityObserver(@NonNull NetworkConnectivityManager connectivityManager, @NonNull Fn.Provider<C4Replicator> replFactory) {
        this.connectivityManager = connectivityManager;
        this.replFactory = replFactory;
    }

    @Override
    public void onConnectivityChanged(boolean connected) {
        C4Replicator c4Repl = this.replFactory.get();
        if (c4Repl == null) {
            return;
        }
        Log.d(LogDomain.NETWORK, "Connectivity change for @%s: %s", this, connected);
        c4Repl.setHostReachable(connected);
    }

    public void handleOffline(@NonNull ReplicatorActivityLevel prevLevel, boolean nowOnline) {
        if (nowOnline) {
            this.connectivityManager.unregisterObserver(this);
            return;
        }
        if (prevLevel.equals((Object)ReplicatorActivityLevel.OFFLINE)) {
            return;
        }
        this.connectivityManager.registerObserver(this);
        this.onConnectivityChanged(this.connectivityManager.isConnected());
    }
}

