/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MValue;
import java.util.ArrayList;
import java.util.List;

public class MArray
extends MCollection {
    @NonNull
    private List<MValue> values = new ArrayList<MValue>();
    @Nullable
    private FLArray baseArray;

    public void initInSlot(@NonNull MValue mv, @Nullable MCollection parent) {
        this.initInSlot(mv, parent, parent != null && parent.hasMutableChildren());
    }

    public void initAsCopyOf(@NonNull MArray array, boolean isMutable) {
        super.initAsCopyOf(array, isMutable);
        this.baseArray = array.getBaseArray();
        this.values = new ArrayList<MValue>(array.values);
    }

    @Nullable
    public FLArray getBaseArray() {
        return this.baseArray;
    }

    public long count() {
        return this.values.size();
    }

    @NonNull
    public MValue get(long index) {
        if (index < 0L || index >= (long)this.values.size()) {
            return MValue.EMPTY;
        }
        MValue value = this.values.get((int)index);
        if (value.isEmpty() && this.baseArray != null) {
            value = new MValue(this.baseArray.get(index));
            this.values.set((int)index, value);
        }
        return value;
    }

    public boolean set(long index, Object value) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot set items in a non-mutable MArray");
        }
        if (index < 0L || index >= this.count()) {
            return false;
        }
        this.mutate();
        this.values.set((int)index, new MValue(value));
        return true;
    }

    public boolean insert(long index, Object value) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot insert items in a non-mutable MArray");
        }
        if (index < 0L || index > this.count()) {
            return false;
        }
        if (index < this.count()) {
            this.populateValues();
        }
        this.mutate();
        this.values.add((int)index, new MValue(value));
        return true;
    }

    public boolean append(Object value) {
        return this.insert(this.count(), value);
    }

    public boolean remove(long start, long num) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot remove items in a non-mutable MArray");
        }
        long end = start + num;
        if (end <= start) {
            return end == start;
        }
        long count = this.count();
        if (end > count) {
            return false;
        }
        if (end < count) {
            this.populateValues();
        }
        this.mutate();
        this.values.subList((int)start, (int)end).clear();
        return true;
    }

    public boolean remove(long index) {
        return this.remove(index, 1L);
    }

    public boolean clear() {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot clear items in a non-mutable MArray");
        }
        if (this.values.isEmpty()) {
            return true;
        }
        this.mutate();
        this.values.clear();
        return true;
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        if (!this.isMutated()) {
            if (this.baseArray != null) {
                enc.writeValue(this.baseArray);
                return;
            }
            enc.beginArray(0L);
            enc.endArray();
            return;
        }
        enc.beginArray(this.count());
        long i = 0L;
        for (MValue value : this.values) {
            if (!value.isEmpty()) {
                value.encodeTo(enc);
            } else if (this.baseArray != null) {
                enc.writeValue(this.baseArray.get(i));
            }
            ++i;
        }
        enc.endArray();
    }

    @Override
    protected void initInSlot(@NonNull MValue mv, MCollection parent, boolean isMutable) {
        super.initInSlot(mv, parent, isMutable);
        if (this.baseArray != null) {
            throw new IllegalStateException("base array is not null.");
        }
        FLValue value = mv.getValue();
        if (value == null) {
            this.baseArray = null;
            this.resize(0L);
            return;
        }
        this.baseArray = value.asFLArray();
        this.resize(this.baseArray.count());
    }

    void resize(long newSize) {
        int count = this.values.size();
        if (newSize < (long)count) {
            this.values.subList((int)newSize, count).clear();
        } else if (newSize > (long)count) {
            int i = 0;
            while ((long)i < newSize - (long)count) {
                this.values.add(MValue.EMPTY);
                ++i;
            }
        }
    }

    void populateValues() {
        if (this.baseArray == null) {
            return;
        }
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            if (!this.values.get(i).isEmpty()) continue;
            this.values.set(i, new MValue(this.baseArray.get(i)));
        }
    }
}

