/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLArrayIterator;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class FLArray {
    private final long peer;

    public FLArray(long peer) {
        Preconditions.assertNotZero(peer, "peer");
        this.peer = peer;
    }

    public long count() {
        return FLArray.count(this.peer);
    }

    @NonNull
    public FLValue get(long index) {
        return new FLValue(FLArray.get(this.peer, index));
    }

    @NonNull
    public List<Object> asArray() {
        return this.asTypedArray();
    }

    @NonNull
    public <T> List<T> asTypedArray() {
        FLValue value;
        ArrayList<Object> results = new ArrayList<Object>();
        FLArrayIterator itr = FLArrayIterator.getManagedArrayIterator();
        itr.begin(this);
        while ((value = itr.getValue()) != null) {
            results.add(value.asObject());
            if (itr.next()) continue;
            break;
        }
        return results;
    }

    @Nullable
    <T> T withContent(@NonNull Fn.Function<Long, T> fn) {
        return fn.apply(this.peer);
    }

    private static native long count(long var0);

    private static native long get(long var0, long var2);
}

