/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.internal.utils.MathUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NativeContext<T> {
    @GuardedBy(value="this")
    @NonNull
    private final Map<Integer, WeakReference<T>> contexts = new HashMap<Integer, WeakReference<T>>();

    public synchronized int reserveKey() {
        int key;
        while (this.contexts.containsKey(key = MathUtils.RANDOM.get().nextInt(Integer.MAX_VALUE))) {
        }
        this.contexts.put(key, null);
        return key;
    }

    public synchronized void bind(int key, @NonNull T obj) {
        if (!this.contexts.containsKey(key)) {
            throw new IllegalStateException("attempt to use un-reserved key");
        }
        if (this.contexts.get(key) != null) {
            throw new IllegalStateException("attempt to rebind key");
        }
        this.contexts.put(key, new WeakReference<T>(obj));
    }

    public synchronized void unbind(int key) {
        this.contexts.remove(key);
    }

    @Nullable
    public synchronized T getObjFromContext(long context) {
        if (context < 0L || context > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Context out of bounds: " + context);
        }
        Integer key = (int)context;
        WeakReference<T> ref = this.contexts.get(key);
        if (ref == null) {
            return null;
        }
        Object obj = ref.get();
        if (obj == null) {
            this.contexts.remove(key);
            return null;
        }
        return obj;
    }

    @VisibleForTesting
    synchronized int size() {
        return this.contexts.size();
    }

    @VisibleForTesting
    synchronized void clear() {
        this.contexts.clear();
    }

    @NonNull
    @VisibleForTesting
    synchronized Set<Integer> keySet() {
        return this.contexts.keySet();
    }
}

