/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.os.Build;
import android.support.annotation.NonNull;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public final class CBLVersion {
    private static final String USER_AGENT_TMPLT = "CouchbaseLite/%s (%s) %s";
    private static final String VERSION_INFO_TMPLT = "CouchbaseLite Android v%s@%s (%s at %s) on %s";
    private static final String LIB_INFO_TMPLT = "%s/%s, Commit/%s Core/%s";
    private static final String SYS_INFO_TMPLT = "Java; Android %s; %s";
    private static final AtomicReference<String> USER_AGENT = new AtomicReference();
    private static final AtomicReference<String> VERSION_INFO = new AtomicReference();
    private static final AtomicReference<String> LIB_INFO = new AtomicReference();
    private static final AtomicReference<String> SYS_INFO = new AtomicReference();

    private CBLVersion() {
    }

    @NonNull
    public static String getUserAgent() {
        String agent = USER_AGENT.get();
        if (agent == null) {
            agent = String.format(Locale.ENGLISH, USER_AGENT_TMPLT, "3.0.5-1", CBLVersion.getSysInfo(), CBLVersion.getLibInfo());
            USER_AGENT.compareAndSet(null, agent);
        }
        return agent;
    }

    @NonNull
    public static String getVersionInfo() {
        String info = VERSION_INFO.get();
        if (info == null) {
            info = String.format(Locale.ENGLISH, VERSION_INFO_TMPLT, "3.0.5-1", CouchbaseLiteInternal.getContext().getApplicationInfo().targetSdkVersion, CBLVersion.getLibInfo(), "2022-10-19T18:22:13.132643Z", CBLVersion.getSysInfo());
            VERSION_INFO.compareAndSet(null, info);
        }
        return info;
    }

    @NonNull
    public static String getLibInfo() {
        String info = LIB_INFO.get();
        if (info == null) {
            info = String.format(Locale.ENGLISH, LIB_INFO_TMPLT, "CE", "release", "unofficial@3e782b88ecec", C4.getVersion());
            LIB_INFO.compareAndSet(null, info);
        }
        return info;
    }

    @NonNull
    public static String getSysInfo() {
        String info = SYS_INFO.get();
        if (info == null) {
            String version = Build.VERSION.RELEASE;
            String model = Build.MODEL;
            info = String.format(Locale.ENGLISH, SYS_INFO_TMPLT, version.length() <= 0 ? "unknown" : version, model.length() <= 0 ? "unknown" : model);
            SYS_INFO.compareAndSet(null, info);
        }
        return info;
    }
}

