/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4FullTextMatch;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLArrayIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class C4QueryEnumerator
extends C4NativePeer {
    C4QueryEnumerator(long peer) {
        super(peer);
    }

    public boolean next() throws LiteCoreException {
        return C4QueryEnumerator.next(this.getPeer());
    }

    public long getRowCount() throws LiteCoreException {
        return C4QueryEnumerator.getRowCount(this.getPeer());
    }

    @Nullable
    public C4QueryEnumerator refresh() throws LiteCoreException {
        long newPeer = C4QueryEnumerator.refresh(this.getPeer());
        return newPeer == 0L ? null : new C4QueryEnumerator(newPeer);
    }

    @NonNull
    public FLArrayIterator getColumns() {
        return FLArrayIterator.getUnmanagedArrayIterator(C4QueryEnumerator.getColumns(this.getPeer()));
    }

    public long getMissingColumns() {
        return C4QueryEnumerator.getMissingColumns(this.getPeer());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NonNull
    public C4QueryEnumerator copy() {
        return this.withPeerOrNull(p -> {
            C4QueryEnumerator.retain(p);
            return new C4QueryEnumerator((long)p);
        });
    }

    @Override
    @CallSuper
    public void close() {
        this.closePeer(null);
    }

    @VisibleForTesting
    public boolean seek(long rowIndex) throws LiteCoreException {
        return C4QueryEnumerator.seek(this.getPeer(), rowIndex);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.QUERY);
        }
        finally {
            super.finalize();
        }
    }

    long getFullTextMatchCount() {
        return C4QueryEnumerator.getFullTextMatchCount(this.getPeer());
    }

    @NonNull
    C4FullTextMatch getFullTextMatches(int idx) {
        return new C4FullTextMatch(C4QueryEnumerator.getFullTextMatch(this.getPeer(), idx));
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4QueryEnumerator::release);
    }

    private static native boolean next(long var0) throws LiteCoreException;

    private static native long getRowCount(long var0) throws LiteCoreException;

    private static native boolean seek(long var0, long var2) throws LiteCoreException;

    private static native long refresh(long var0) throws LiteCoreException;

    private static native void close(long var0);

    private static native void retain(long var0);

    private static native void release(long var0);

    private static native long getColumns(long var0);

    private static native long getMissingColumns(long var0);

    private static native long getFullTextMatchCount(long var0);

    private static native long getFullTextMatch(long var0, int var2);
}

