/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.connectivity;

import android.net.ConnectivityManager;
import android.net.Network;
import android.support.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.connectivity.AndroidConnectivityManager;
import com.couchbase.lite.internal.connectivity.ConnectivityWatcher;
import com.couchbase.lite.internal.support.Log;

abstract class CallbackConnectivityWatcher
extends ConnectivityWatcher {
    @NonNull
    protected final ConnectivityManager.NetworkCallback connectivityCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(@NonNull Network ignore) {
            CallbackConnectivityWatcher.this.onConnectivityChange(CallbackConnectivityWatcher.this.isConnected());
        }

        public void onLost(@NonNull Network ignore) {
            CallbackConnectivityWatcher.this.onConnectivityChange(CallbackConnectivityWatcher.this.isConnected());
        }
    };

    CallbackConnectivityWatcher(@NonNull String name, @NonNull AndroidConnectivityManager mgr) {
        super(name, mgr);
    }

    @Override
    public final void stop() {
        ConnectivityManager connectivityMgr = this.getSysMgr();
        if (connectivityMgr == null) {
            return;
        }
        String msg = this.name + " network listener for " + this.getCblMgr() + ": " + this;
        try {
            connectivityMgr.unregisterNetworkCallback(this.connectivityCallback);
        }
        catch (RuntimeException e) {
            Log.w(LogDomain.NETWORK, "Failed stopping " + msg, e);
            return;
        }
        Log.d(LogDomain.NETWORK, "Stopped: %s", msg);
    }
}

