/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.connectivity;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.internal.connectivity.ConnectivityListener21to23;
import com.couchbase.lite.internal.connectivity.ConnectivityListener24to28;
import com.couchbase.lite.internal.connectivity.ConnectivityListenerPost28;
import com.couchbase.lite.internal.connectivity.ConnectivityWatcher;
import com.couchbase.lite.internal.replicator.NetworkConnectivityManager;
import com.couchbase.lite.internal.utils.Fn;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class AndroidConnectivityManager
implements NetworkConnectivityManager {
    @GuardedBy(value="observers")
    @NonNull
    private final WeakHashMap<NetworkConnectivityManager.Observer, Boolean> observers = new WeakHashMap();
    @NonNull
    private final AtomicReference<ConnectivityWatcher> listener = new AtomicReference<Object>(null);
    @NonNull
    private final Fn.Runner runner;
    private final int androidVersion;

    @NonNull
    public static AndroidConnectivityManager newInstance() {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        return new AndroidConnectivityManager(arg_0 -> ((Handler)mainHandler).post(arg_0));
    }

    AndroidConnectivityManager(@NonNull Fn.Runner runner) {
        this(Build.VERSION.SDK_INT, runner);
    }

    @VisibleForTesting
    public AndroidConnectivityManager(int androidVersion, @NonNull Fn.Runner runner) {
        this.runner = runner;
        this.androidVersion = androidVersion;
    }

    @Override
    public boolean isConnected() {
        ConnectivityWatcher connectivityListener = this.listener.get();
        return connectivityListener != null && connectivityListener.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObserver(@NonNull NetworkConnectivityManager.Observer observer) {
        boolean shouldStart;
        WeakHashMap<NetworkConnectivityManager.Observer, Boolean> weakHashMap = this.observers;
        synchronized (weakHashMap) {
            shouldStart = this.observers.isEmpty();
            this.observers.put(observer, Boolean.TRUE);
        }
        if (shouldStart) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterObserver(@NonNull NetworkConnectivityManager.Observer observer) {
        boolean shouldStop;
        WeakHashMap<NetworkConnectivityManager.Observer, Boolean> weakHashMap = this.observers;
        synchronized (weakHashMap) {
            this.observers.remove(observer);
            shouldStop = this.observers.isEmpty();
        }
        if (shouldStop) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectivityChanged(boolean connected) {
        HashSet<NetworkConnectivityManager.Observer> obs;
        WeakHashMap<NetworkConnectivityManager.Observer, Boolean> weakHashMap = this.observers;
        synchronized (weakHashMap) {
            obs = new HashSet<NetworkConnectivityManager.Observer>(this.observers.keySet());
        }
        if (obs.isEmpty()) {
            this.stop();
            return;
        }
        for (NetworkConnectivityManager.Observer observer : obs) {
            this.runner.run(() -> observer.onConnectivityChanged(connected));
        }
    }

    @VisibleForTesting
    public boolean isRunning() {
        return this.listener.get() != null;
    }

    @SuppressLint(value={"NewApi"})
    private void start() {
        ConnectivityWatcher connectivityListener = this.listener.get();
        if (connectivityListener != null) {
            return;
        }
        connectivityListener = this.androidVersion < 24 ? new ConnectivityListener21to23(this) : (this.androidVersion < 29 ? new ConnectivityListener24to28(this) : new ConnectivityListenerPost28(this));
        if (this.listener.compareAndSet(null, connectivityListener)) {
            connectivityListener.start();
        }
    }

    private void stop() {
        ConnectivityWatcher connectivityListener = this.listener.getAndSet(null);
        if (connectivityListener != null) {
            connectivityListener.stop();
        }
    }
}

