/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.R;
import com.couchbase.lite.internal.AndroidExecutionService;
import com.couchbase.lite.internal.connectivity.AndroidConnectivityManager;
import com.couchbase.lite.internal.core.C4Base;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.replicator.NetworkConnectivityManager;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public final class CouchbaseLiteInternal {
    public static final String SCRATCH_DIR_NAME = "CouchbaseLiteTemp";
    private static final String LITECORE_JNI_LIBRARY = "LiteCoreJNI";
    private static final AtomicReference<SoftReference<Context>> CONTEXT = new AtomicReference();
    private static final AtomicReference<ExecutionService> EXECUTION_SERVICE = new AtomicReference();
    private static final AtomicReference<NetworkConnectivityManager> CONNECTIVITY_MANAGER = new AtomicReference();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final Object LOCK = new Object();
    private static volatile boolean debugging;
    private static volatile File rootDir;
    private static volatile File scratchDir;

    private CouchbaseLiteInternal() {
    }

    public static void init(@NonNull MValue.Delegate mValueDelegate, boolean debug, @NonNull File rootDir, @NonNull File scratchDir, @NonNull Context ctxt) {
        if (INITIALIZED.getAndSet(true)) {
            return;
        }
        debugging = debug;
        CONTEXT.set(new SoftReference<Context>(Preconditions.assertNotNull(ctxt.getApplicationContext(), "context")));
        Preconditions.assertNotNull(mValueDelegate, "mValueDelegate");
        CouchbaseLiteInternal.rootDir = Preconditions.assertNotNull(FileUtils.verifyDir(rootDir), "rootDir");
        CouchbaseLiteInternal.scratchDir = Preconditions.assertNotNull(FileUtils.verifyDir(scratchDir), "scratchDir");
        System.loadLibrary(LITECORE_JNI_LIBRARY);
        C4Base.debug(debugging);
        Log.initLogging(CouchbaseLiteInternal.loadErrorMessages(ctxt));
        CouchbaseLiteInternal.setC4TmpDirPath(scratchDir);
        MValue.registerDelegate(mValueDelegate);
    }

    @NonNull
    public static Context getContext() {
        CouchbaseLiteInternal.requireInit("Application context not initialized");
        SoftReference<Context> contextRef = CONTEXT.get();
        Context ctxt = contextRef.get();
        if (ctxt == null) {
            throw new IllegalStateException("Context is null");
        }
        return ctxt;
    }

    public static boolean debugging() {
        return debugging;
    }

    @NonNull
    public static NetworkConnectivityManager getNetworkConnectivityManager() {
        NetworkConnectivityManager connectivityMgr = CONNECTIVITY_MANAGER.get();
        if (connectivityMgr != null) {
            return connectivityMgr;
        }
        CONNECTIVITY_MANAGER.compareAndSet(null, AndroidConnectivityManager.newInstance());
        return CONNECTIVITY_MANAGER.get();
    }

    @NonNull
    public static ExecutionService getExecutionService() {
        ExecutionService executionService = EXECUTION_SERVICE.get();
        if (executionService != null) {
            return executionService;
        }
        EXECUTION_SERVICE.compareAndSet(null, new AndroidExecutionService());
        return EXECUTION_SERVICE.get();
    }

    public static void requireInit(String message) {
        if (!INITIALIZED.get()) {
            throw new IllegalStateException(message + ".  Did you forget to call CouchbaseLite.init()?");
        }
    }

    @NonNull
    public static File getRootDir() {
        CouchbaseLiteInternal.requireInit("Can't create DB path");
        return rootDir;
    }

    @NonNull
    public static String getRootDirPath() {
        return rootDir.getAbsolutePath();
    }

    @NonNull
    public static File getScratchDir() {
        CouchbaseLiteInternal.requireInit("Can't create Scratch path");
        return scratchDir;
    }

    @NonNull
    public static String getScratchDirPath() {
        return scratchDir.getAbsolutePath();
    }

    @VisibleForTesting
    public static void reset(boolean state) {
        INITIALIZED.set(state);
    }

    @VisibleForTesting
    @NonNull
    public static Map<String, String> loadErrorMessages(@NonNull Context ctxt) {
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        try (InputStream is = ctxt.getResources().openRawResource(R.raw.errors);){
            JSONObject root = new JSONObject(new Scanner(is, "UTF-8").useDelimiter("\\A").next());
            Iterable errors = () -> ((JSONObject)root).keys();
            for (String error : errors) {
                errorMessages.put(error, root.getString(error));
            }
        }
        catch (IOException | JSONException e) {
            Log.w(LogDomain.DATABASE, "Failed to load error messages", e);
        }
        return errorMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setC4TmpDirPath(@NonNull File scratchDir) {
        try {
            Object object = LOCK;
            synchronized (object) {
                C4Base.setTempDir(scratchDir.getAbsolutePath());
            }
        }
        catch (LiteCoreException e) {
            Log.w(LogDomain.DATABASE, "Failed to set c4TmpDir", e);
        }
    }
}

