/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.net.URI;

public final class URLEndpoint
implements Endpoint {
    static final String SCHEME_STD = "ws";
    static final String SCHEME_TLS = "wss";
    @NonNull
    private final URI url;

    public URLEndpoint(@NonNull URI url) {
        Preconditions.assertNotNull(url, "url");
        String scheme = url.getScheme();
        if (!SCHEME_STD.equals(scheme) && !SCHEME_TLS.equals(scheme)) {
            throw new IllegalArgumentException(Log.formatStandardMessage("InvalidSchemeURLEndpoint", url.toString()));
        }
        String userInfo = url.getUserInfo();
        if (userInfo != null && userInfo.split(":").length == 2) {
            throw new IllegalArgumentException(Log.lookupStandardMessage("InvalidEmbeddedCredentialsInURL"));
        }
        this.url = url;
    }

    @NonNull
    public String toString() {
        return "URLEndpoint{url=" + this.url + '}';
    }

    @NonNull
    public URI getURL() {
        return this.url;
    }
}

