/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractReplicatorConfiguration;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.Database;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.ImmutableReplicatorConfiguration;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.List;
import java.util.Map;

public final class ReplicatorConfiguration
extends AbstractReplicatorConfiguration {
    public ReplicatorConfiguration(@NonNull Database database, @NonNull Endpoint target) {
        super(Preconditions.assertNotNull(database, "database"), Preconditions.assertNotNull(target, "target"));
    }

    public ReplicatorConfiguration(@NonNull ReplicatorConfiguration config) {
        super(config);
    }

    ReplicatorConfiguration(@NonNull ImmutableReplicatorConfiguration config) {
        super(config);
    }

    ReplicatorConfiguration(@NonNull Database database, @NonNull ReplicatorType type, boolean continuous, @Nullable Authenticator authenticator, @Nullable Map<String, String> headers, @Nullable byte[] pinnedServerCertificate, @Nullable List<String> channels, @Nullable List<String> documentIDs, @Nullable ReplicationFilter pushFilter, @Nullable ReplicationFilter pullFilter, @Nullable ConflictResolver conflictResolver, int maxAttempts, int maxAttemptWaitTime, int heartbeat, boolean enableAutoPurge, @NonNull Endpoint target) {
        super(Preconditions.assertNotNull(database, "database"), Preconditions.assertNotNull(type, "type"), continuous, authenticator, headers, ReplicatorConfiguration.copyCert(pinnedServerCertificate), channels, documentIDs, pushFilter, pullFilter, conflictResolver, maxAttempts, maxAttemptWaitTime, ReplicatorConfiguration.verifyHeartbeat(heartbeat), enableAutoPurge, Preconditions.assertNotNull(target, "target"));
    }

    @Override
    @NonNull
    protected ReplicatorConfiguration getReplicatorConfiguration() {
        return this;
    }
}

