/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Expression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;

public abstract class Ordering {
    @NonNull
    public static SortOrder property(@NonNull String property) {
        Preconditions.assertNotNull(property, "property");
        return Ordering.expression(Expression.property(property));
    }

    @NonNull
    public static SortOrder expression(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, "expression");
        return new SortOrder(expression);
    }

    @Nullable
    abstract Object asJSON();

    public static class SortOrder
    extends Ordering {
        @NonNull
        private final Expression expression;
        private boolean isAscending;

        SortOrder(@NonNull Expression expression) {
            this.expression = expression;
            this.isAscending = true;
        }

        @NonNull
        public Ordering ascending() {
            this.isAscending = true;
            return this;
        }

        @NonNull
        public Ordering descending() {
            this.isAscending = false;
            return this;
        }

        @Override
        @Nullable
        Object asJSON() {
            if (this.isAscending) {
                return this.expression.asJSON();
            }
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("DESC");
            json.add(this.expression.asJSON());
            return json;
        }
    }
}

