/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;

final class N1qlQuery
extends AbstractQuery {
    @NonNull
    private final String n1ql;
    @NonNull
    private final AbstractDatabase db;

    N1qlQuery(@NonNull AbstractDatabase db, @NonNull String n1ql) {
        this.n1ql = Preconditions.assertNotNull(n1ql, "query");
        this.db = Preconditions.assertNotNull(db, "database");
    }

    @NonNull
    public String toString() {
        return "N1qlQuery{" + ClassUtils.objId(this) + ", n1ql=" + this.n1ql + "}";
    }

    @Override
    @NonNull
    protected AbstractDatabase getDatabase() {
        return this.db;
    }

    @Override
    @GuardedBy(value="AbstractQuery.lock")
    @NonNull
    protected C4Query prepQueryLocked(@NonNull AbstractDatabase db) throws CouchbaseLiteException {
        Log.d(DOMAIN, "N1QL query: %s", this.n1ql);
        if (StringUtils.isEmpty(this.n1ql)) {
            throw new CouchbaseLiteException("Query is null or empty.");
        }
        try {
            return db.createN1qlQuery(this.n1ql);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    void compile() throws CouchbaseLiteException {
        this.getC4Query();
    }
}

