/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionaryInterface;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MDict;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class MutableDictionary
extends Dictionary
implements MutableDictionaryInterface {
    public MutableDictionary() {
    }

    public MutableDictionary(@NonNull Map<String, Object> data) {
        this.setData((Map)data);
    }

    public MutableDictionary(@NonNull String json) {
        this.setJSON(json);
    }

    MutableDictionary(@NonNull MDict mDict, boolean isMutable) {
        super(mDict, isMutable);
    }

    MutableDictionary(@NonNull MValue mv, @Nullable MCollection parent) {
        super(mv, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setData(@NonNull Map<String, Object> data) {
        Object object = this.lock;
        synchronized (object) {
            this.internalDict.clear();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Object obj = entry.getValue();
                this.checkSelf(obj);
                this.internalDict.set(Preconditions.assertNotNull(entry.getKey(), "data key"), new MValue(Fleece.toCBLObject(obj)));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setJSON(@NonNull String json) {
        Object object = this.lock;
        synchronized (object) {
            this.internalDict.clear();
            try {
                this.setData((Map)JSONUtils.fromJSON(new JSONObject(json)));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Failed parsing JSON", e);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setValue(@NonNull String key, @Nullable Object value) {
        Preconditions.assertNotNull(key, "key");
        this.checkSelf(value);
        Object object = this.lock;
        synchronized (object) {
            value = Fleece.toCBLObject(value);
            if (Fleece.willMutate(value, this.internalDict.get(key), this.internalDict)) {
                this.internalDict.set(key, new MValue(value));
            }
            return this;
        }
    }

    @Override
    @NonNull
    public MutableDictionary setString(@NonNull String key, @Nullable String value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setNumber(@NonNull String key, @Nullable Number value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setInt(@NonNull String key, int value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setLong(@NonNull String key, long value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setFloat(@NonNull String key, float value) {
        return this.setValue(key, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableDictionary setDouble(@NonNull String key, double value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setBoolean(@NonNull String key, boolean value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setBlob(@NonNull String key, @NonNull Blob value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setDate(@NonNull String key, @NonNull Date value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setArray(@NonNull String key, @NonNull Array value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setDictionary(@NonNull String key, @NonNull Dictionary value) {
        this.checkSelf(value);
        return this.setValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary remove(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            this.internalDict.remove(key);
            return this;
        }
    }

    @Override
    @Nullable
    public MutableArray getArray(@NonNull String key) {
        return (MutableArray)super.getArray(key);
    }

    @Override
    @Nullable
    public MutableDictionary getDictionary(@NonNull String key) {
        return (MutableDictionary)super.getDictionary(key);
    }

    @Override
    @NonNull
    public String toJSON() {
        throw new IllegalStateException("Mutable objects may not be encoded as JSON");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isChanged() {
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict.isMutated();
        }
    }

    private void checkSelf(Object value) {
        if (value == this) {
            throw new IllegalArgumentException("Dictionaries cannot ba added to themselves");
        }
    }
}

