/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.DocumentReplication;
import com.couchbase.lite.DocumentReplicationListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;

final class DocumentReplicationListenerToken
implements ListenerToken {
    @NonNull
    private final DocumentReplicationListener listener;
    @Nullable
    private final Executor executor;

    DocumentReplicationListenerToken(@Nullable Executor executor, @NonNull DocumentReplicationListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        this.executor = executor;
        this.listener = listener;
    }

    void notify(@NonNull DocumentReplication update) {
        this.getExecutor().execute(() -> this.listener.replication(update));
    }

    @NonNull
    Executor getExecutor() {
        return this.executor != null ? this.executor : CouchbaseLiteInternal.getExecutionService().getDefaultExecutor();
    }
}

