/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Database;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class DataSource {
    @NonNull
    private final Object source;
    @Nullable
    protected String alias;

    @NonNull
    public static As database(@NonNull Database database) {
        Preconditions.assertNotNull(database, "database");
        return new As(database);
    }

    private DataSource(@NonNull Object source) {
        this.source = source;
    }

    @NonNull
    Object getSource() {
        return this.source;
    }

    @Nullable
    String getColumnName() {
        if (this.alias != null) {
            return this.alias;
        }
        return !(this.source instanceof Database) ? null : ((Database)this.source).getName();
    }

    @NonNull
    Map<String, Object> asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("AS", this.getColumnName());
        return json;
    }

    public static class As
    extends DataSource {
        As(@NonNull Database source) {
            super(source);
        }

        @NonNull
        public DataSource as(@NonNull String alias) {
            Preconditions.assertNotNull(alias, "alias");
            this.alias = alias;
            return this;
        }
    }
}

