/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.Database;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.internal.BaseImmutableReplicatorConfiguration;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.internal.Util;

public abstract class AbstractReplicatorConfiguration {
    public static final int DISABLE_HEARTBEAT = 2147483;
    @NonNull
    private final Database database;
    @NonNull
    private com.couchbase.lite.ReplicatorType type;
    private boolean continuous;
    @Nullable
    private Authenticator authenticator;
    @Nullable
    private Map<String, String> headers;
    @Nullable
    private byte[] pinnedServerCertificate;
    @Nullable
    private List<String> channels;
    @Nullable
    private List<String> documentIDs;
    @Nullable
    private ReplicationFilter pushFilter;
    @Nullable
    private ReplicationFilter pullFilter;
    @Nullable
    private ConflictResolver conflictResolver;
    private int maxAttempts;
    private int maxAttemptWaitTime;
    private int heartbeat;
    private boolean enableAutoPurge = true;
    @NonNull
    private final Endpoint target;

    protected static int verifyHeartbeat(int heartbeat) {
        Util.checkDuration((String)"heartbeat", (long)Preconditions.assertNotNegative(heartbeat, "heartbeat"), (TimeUnit)TimeUnit.SECONDS);
        return heartbeat;
    }

    @Nullable
    protected static byte[] copyCert(@Nullable byte[] cert) {
        if (cert == null) {
            return null;
        }
        byte[] newCert = new byte[cert.length];
        System.arraycopy(cert, 0, newCert, 0, newCert.length);
        return newCert;
    }

    protected AbstractReplicatorConfiguration(@NonNull Database database, @NonNull Endpoint target) {
        this.database = database;
        this.type = com.couchbase.lite.ReplicatorType.PUSH_AND_PULL;
        this.target = target;
    }

    protected AbstractReplicatorConfiguration(@NonNull AbstractReplicatorConfiguration config) {
        this(Preconditions.assertNotNull(config, (String)"config").database, config.type, config.continuous, config.authenticator, config.headers, config.pinnedServerCertificate, config.channels, config.documentIDs, config.pullFilter, config.pushFilter, config.conflictResolver, config.maxAttempts, config.maxAttemptWaitTime, config.heartbeat, config.enableAutoPurge, config.target);
    }

    protected AbstractReplicatorConfiguration(@NonNull BaseImmutableReplicatorConfiguration config) {
        this(Preconditions.assertNotNull(config, "config").getDatabase(), config.getType(), config.isContinuous(), config.getAuthenticator(), config.getHeaders(), config.getPinnedServerCertificate(), config.getChannels(), config.getDocumentIDs(), config.getPullFilter(), config.getPushFilter(), config.getConflictResolver(), config.getMaxRetryAttempts(), config.getMaxRetryAttemptWaitTime(), config.getHeartbeat(), config.isAutoPurgeEnabled(), config.getTarget());
    }

    protected AbstractReplicatorConfiguration(@NonNull Database database, @NonNull com.couchbase.lite.ReplicatorType type, boolean continuous, @Nullable Authenticator authenticator, @Nullable Map<String, String> headers, @Nullable byte[] pinnedServerCertificate, @Nullable List<String> channels, @Nullable List<String> documentIDs, @Nullable ReplicationFilter pushFilter, @Nullable ReplicationFilter pullFilter, @Nullable ConflictResolver conflictResolver, int maxAttempts, int maxAttemptWaitTime, int heartbeat, boolean enableAutoPurge, @NonNull Endpoint target) {
        this.database = database;
        this.type = type;
        this.continuous = continuous;
        this.authenticator = authenticator;
        this.headers = headers;
        this.pinnedServerCertificate = pinnedServerCertificate;
        this.channels = channels;
        this.documentIDs = documentIDs;
        this.pullFilter = pullFilter;
        this.pushFilter = pushFilter;
        this.conflictResolver = conflictResolver;
        this.maxAttempts = maxAttempts;
        this.maxAttemptWaitTime = maxAttemptWaitTime;
        this.heartbeat = heartbeat;
        this.enableAutoPurge = enableAutoPurge;
        this.target = target;
    }

    @NonNull
    public final ReplicatorConfiguration setAuthenticator(@NonNull Authenticator authenticator) {
        this.authenticator = Preconditions.assertNotNull(authenticator, "authenticator");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setChannels(@Nullable List<String> channels) {
        this.channels = channels == null ? null : new ArrayList<String>(channels);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setConflictResolver(@Nullable ConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setContinuous(boolean continuous) {
        this.continuous = continuous;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setDocumentIDs(@Nullable List<String> documentIDs) {
        this.documentIDs = documentIDs == null ? null : new ArrayList<String>(documentIDs);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setHeaders(@Nullable Map<String, String> headers) {
        this.headers = headers == null ? null : new HashMap<String, String>(headers);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setPinnedServerCertificate(@Nullable byte[] pinnedCert) {
        this.pinnedServerCertificate = AbstractReplicatorConfiguration.copyCert(pinnedCert);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setPullFilter(@Nullable ReplicationFilter pullFilter) {
        this.pullFilter = pullFilter;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setPushFilter(@Nullable ReplicationFilter pushFilter) {
        this.pushFilter = pushFilter;
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setReplicatorType(@NonNull ReplicatorType replicatorType) {
        com.couchbase.lite.ReplicatorType type;
        switch (Preconditions.assertNotNull(replicatorType, "replicator type")) {
            case PUSH_AND_PULL: {
                type = com.couchbase.lite.ReplicatorType.PUSH_AND_PULL;
                break;
            }
            case PUSH: {
                type = com.couchbase.lite.ReplicatorType.PUSH;
                break;
            }
            case PULL: {
                type = com.couchbase.lite.ReplicatorType.PULL;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized replicator type: " + (Object)((Object)replicatorType));
            }
        }
        return this.setType(type);
    }

    @NonNull
    public final ReplicatorConfiguration setType(@NonNull com.couchbase.lite.ReplicatorType type) {
        this.type = Preconditions.assertNotNull(type, "replicator type");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setMaxAttempts(int maxAttempts) {
        this.maxAttempts = Preconditions.assertNotNegative(maxAttempts, "max attempts");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setMaxAttemptWaitTime(int maxAttemptWaitTime) {
        this.maxAttemptWaitTime = Preconditions.assertNotNegative(maxAttemptWaitTime, "max attempt wait time");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setHeartbeat(int heartbeat) {
        this.heartbeat = AbstractReplicatorConfiguration.verifyHeartbeat(heartbeat);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setAutoPurgeEnabled(boolean enabled) {
        this.enableAutoPurge = enabled;
        return this.getReplicatorConfiguration();
    }

    @Nullable
    public final Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public final List<String> getChannels() {
        return this.channels == null ? null : new ArrayList<String>(this.channels);
    }

    @Nullable
    public final ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public final boolean isContinuous() {
        return this.continuous;
    }

    @NonNull
    public final Database getDatabase() {
        return this.database;
    }

    @Nullable
    public final List<String> getDocumentIDs() {
        return this.documentIDs == null ? null : new ArrayList<String>(this.documentIDs);
    }

    @Nullable
    public final Map<String, String> getHeaders() {
        return this.headers == null ? null : new HashMap<String, String>(this.headers);
    }

    @Nullable
    public final byte[] getPinnedServerCertificate() {
        return AbstractReplicatorConfiguration.copyCert(this.pinnedServerCertificate);
    }

    @Nullable
    public final ReplicationFilter getPullFilter() {
        return this.pullFilter;
    }

    @Nullable
    public final ReplicationFilter getPushFilter() {
        return this.pushFilter;
    }

    @Deprecated
    @NonNull
    public final ReplicatorType getReplicatorType() {
        switch (this.type) {
            case PUSH_AND_PULL: {
                return ReplicatorType.PUSH_AND_PULL;
            }
            case PUSH: {
                return ReplicatorType.PUSH;
            }
            case PULL: {
                return ReplicatorType.PULL;
            }
        }
        throw new IllegalStateException("Unrecognized replicator type: " + (Object)((Object)this.type));
    }

    @NonNull
    public final com.couchbase.lite.ReplicatorType getType() {
        return this.type;
    }

    @NonNull
    public final Endpoint getTarget() {
        return this.target;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final int getMaxAttemptWaitTime() {
        return this.maxAttemptWaitTime;
    }

    public final int getHeartbeat() {
        return this.heartbeat;
    }

    public final boolean isAutoPurgeEnabled() {
        return this.enableAutoPurge;
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.pullFilter != null) {
            buf.append('|');
        }
        if (this.type == com.couchbase.lite.ReplicatorType.PULL || this.type == com.couchbase.lite.ReplicatorType.PUSH_AND_PULL) {
            buf.append('<');
        }
        buf.append(this.continuous ? (char)'*' : '=');
        if (this.type == com.couchbase.lite.ReplicatorType.PUSH || this.type == com.couchbase.lite.ReplicatorType.PUSH_AND_PULL) {
            buf.append('>');
        }
        if (this.pushFilter != null) {
            buf.append('|');
        }
        buf.append('(');
        if (this.authenticator != null) {
            buf.append('@');
        }
        if (this.pinnedServerCertificate != null) {
            buf.append('^');
        }
        buf.append(')');
        if (this.conflictResolver != null) {
            buf.append('!');
        }
        return "ReplicatorConfig{" + this.database + buf.toString() + this.target + '}';
    }

    @NonNull
    abstract ReplicatorConfiguration getReplicatorConfiguration();

    @Deprecated
    public static enum ReplicatorType {
        PUSH_AND_PULL,
        PUSH,
        PULL;

    }
}

