/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LiveQuery;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.Parameters;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryChangeListener;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.core.C4QueryOptions;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

abstract class AbstractQuery
implements Query {
    protected static final LogDomain DOMAIN = LogDomain.QUERY;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Map<String, Integer> columnNames;
    @GuardedBy(value="lock")
    private C4Query c4query;
    @GuardedBy(value="lock")
    private LiveQuery liveQuery;
    @Nullable
    private Parameters parameters;

    AbstractQuery() {
    }

    @Override
    @Nullable
    public Parameters getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameters(@Nullable Parameters parameters) {
        LiveQuery newQuery;
        Object object = this.lock;
        synchronized (object) {
            this.parameters = parameters == null ? null : parameters.readonlyCopy();
            newQuery = this.liveQuery;
        }
        if (newQuery != null) {
            newQuery.start(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ResultSet execute() throws CouchbaseLiteException {
        try {
            Map<String, Integer> colNames;
            C4QueryEnumerator c4enum;
            C4QueryOptions options = new C4QueryOptions();
            if (this.parameters == null) {
                this.parameters = new Parameters();
            }
            try (FLSliceResult params = this.parameters.encode();){
                Object object = this.getDbLock();
                synchronized (object) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        c4enum = this.getC4QueryLocked().run(options, params);
                        colNames = this.columnNames;
                    }
                }
            }
            return new ResultSet(this, c4enum, new HashMap<String, Integer>(colNames));
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String explain() throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                String exp = this.getC4QueryLocked().explain();
                if (exp == null) {
                    throw new CouchbaseLiteException("Could not explain query");
                }
                return exp;
            }
        }
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@NonNull QueryChangeListener listener) {
        return this.addChangeListener(null, listener);
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull QueryChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        return this.getLiveQuery().addChangeListener(executor, listener);
    }

    @Override
    public void removeChangeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        this.getLiveQuery().removeChangeListener(token);
    }

    @NonNull
    protected abstract C4Query prepQueryLocked(@NonNull AbstractDatabase var1) throws CouchbaseLiteException;

    @Nullable
    protected abstract AbstractDatabase getDatabase();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getC4Query() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            this.getC4QueryLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    LiveQuery getLiveQuery() {
        Object object = this.lock;
        synchronized (object) {
            if (this.liveQuery == null) {
                this.liveQuery = new LiveQuery(this);
            }
            return this.liveQuery;
        }
    }

    @GuardedBy(value="lock")
    @NonNull
    private C4Query getC4QueryLocked() throws CouchbaseLiteException {
        if (this.c4query != null) {
            return this.c4query;
        }
        AbstractDatabase db = this.getDatabase();
        if (db == null) {
            throw new IllegalStateException("Attempt to prep query with no database");
        }
        C4Query c4Q = this.prepQueryLocked(db);
        int nCols = c4Q.getColumnCount();
        HashMap<String, Integer> colNames = new HashMap<String, Integer>();
        for (int i = 0; i < nCols; ++i) {
            String colName = c4Q.getColumnNameForIndex(i);
            if (colName == null) continue;
            if (colNames.containsKey(colName)) {
                throw new CouchbaseLiteException(Log.formatStandardMessage("DuplicateSelectResultName", colName), "CouchbaseLite", 23);
            }
            colNames.put(colName, i);
        }
        this.columnNames = colNames;
        this.c4query = c4Q;
        return this.c4query;
    }

    @NonNull
    private Object getDbLock() {
        AbstractDatabase db = this.getDatabase();
        if (db != null) {
            return db.getDbLock();
        }
        throw new IllegalStateException("Cannot seize DB lock");
    }
}

