/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.internal.BaseImmutableDatabaseConfiguration;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Preconditions;

abstract class AbstractDatabaseConfiguration {
    private String dbDirectory;

    protected AbstractDatabaseConfiguration() {
        this((String)null);
    }

    protected AbstractDatabaseConfiguration(@Nullable AbstractDatabaseConfiguration config) {
        this(config == null ? null : config.getDirectory());
    }

    protected AbstractDatabaseConfiguration(@Nullable BaseImmutableDatabaseConfiguration config) {
        this(config == null ? null : config.getDirectory());
    }

    protected AbstractDatabaseConfiguration(@Nullable String dbDir) {
        CouchbaseLiteInternal.requireInit("Cannot create database configuration");
        this.dbDirectory = dbDir != null ? dbDir : CouchbaseLiteInternal.getRootDirPath();
    }

    @NonNull
    public DatabaseConfiguration setDirectory(@NonNull String directory) {
        Preconditions.assertNotNull(directory, "directory");
        this.dbDirectory = FileUtils.verifyDir(directory).getAbsolutePath();
        return this.getDatabaseConfiguration();
    }

    @NonNull
    public String getDirectory() {
        return this.dbDirectory;
    }

    @NonNull
    protected abstract DatabaseConfiguration getDatabaseConfiguration();
}

