/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.fleece.Encodable;
import com.couchbase.litecore.fleece.MContext;
import com.couchbase.litecore.fleece.MValue;

public abstract class MCollection
implements Encodable {
    private MValue _slot;
    private MContext _context;
    private boolean _isMutable;
    private boolean _isMutated;
    private boolean _mutableChildren;
    private MCollection _parent;

    protected MCollection() {
        this(MContext.NULL, true);
    }

    protected MCollection(MContext context, boolean isMutable) {
        this._context = context;
        this._isMutable = isMutable;
        this._mutableChildren = isMutable;
    }

    public MContext getContext() {
        return this._context;
    }

    public boolean isMutable() {
        return this._isMutable;
    }

    public boolean isMutated() {
        return this._isMutated;
    }

    public boolean getMutableChildren() {
        return this._mutableChildren;
    }

    public void initAsCopyOf(MCollection original, boolean isMutable) {
        if (this._context != MContext.NULL) {
            throw new IllegalStateException("Current context is not null.");
        }
        this._context = original.getContext();
        this._isMutable = isMutable;
        this._mutableChildren = isMutable;
    }

    protected void setSlot(MValue newSlot, MValue oldSlot) {
        if (this._slot.equals(oldSlot)) {
            this._slot = newSlot;
            if (newSlot == null) {
                this._parent = null;
            }
        }
    }

    protected void initInSlot(MValue slot, MCollection parent, boolean isMutable) {
        if (slot == null) {
            throw new IllegalArgumentException("slot cannot be null.");
        }
        if (this._context != MContext.NULL) {
            throw new IllegalStateException("Current context is not MContext.Null");
        }
        this._slot = slot;
        this._parent = parent;
        this._isMutable = isMutable;
        this._mutableChildren = isMutable;
        this._isMutated = this._slot.isMutated();
        if (this._slot.getValue() != null) {
            this._context = parent != null ? parent.getContext() : null;
        }
    }

    protected void mutate() {
        if (!this._isMutable) {
            throw new IllegalStateException("The collection object is not mutable.");
        }
        if (!this._isMutated) {
            this._isMutated = true;
            if (this._slot != null) {
                this._slot.mutate();
            }
            if (this._parent != null) {
                this._parent.mutate();
            }
        }
    }
}

