/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.fleece.Encoder;
import com.couchbase.litecore.fleece.FLArray;
import com.couchbase.litecore.fleece.FLValue;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MValue;
import java.util.ArrayList;
import java.util.List;

public class MArray
extends MCollection {
    private List<MValue> _values = new ArrayList<MValue>();
    private FLArray _baseArray;

    public void initInSlot(MValue mv, MCollection parent) {
        this.initInSlot(mv, parent, parent != null ? parent.getMutableChildren() : false);
    }

    @Override
    protected void initInSlot(MValue mv, MCollection parent, boolean isMutable) {
        super.initInSlot(mv, parent, isMutable);
        if (this._baseArray != null) {
            throw new IllegalStateException("base array is not null.");
        }
        FLValue value = mv.getValue();
        if (value != null) {
            this._baseArray = value.asFLArray();
            this.resize(this._baseArray.count());
        } else {
            this._baseArray = null;
            this.resize(0L);
        }
    }

    public void initAsCopyOf(MArray array, boolean isMutable) {
        super.initAsCopyOf(array, isMutable);
        this._baseArray = array != null ? array.getBaseArray() : null;
        this._values = array != null ? new ArrayList<MValue>(array._values) : new ArrayList();
    }

    public long count() {
        return this._values.size();
    }

    public FLArray getBaseArray() {
        return this._baseArray;
    }

    public MValue get(long index) {
        if (index < 0L || index >= (long)this._values.size()) {
            return MValue.EMPTY;
        }
        MValue value = this._values.get((int)index);
        if (value.isEmpty() && this._baseArray != null) {
            value = new MValue(this._baseArray.get(index));
            this._values.set((int)index, value);
        }
        return value;
    }

    public boolean set(long index, Object value) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot set items in a non-mutable MArray");
        }
        if (index < 0L || index >= this.count()) {
            return false;
        }
        this.mutate();
        this._values.set((int)index, new MValue(value));
        return true;
    }

    public boolean insert(long index, Object value) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot insert items in a non-mutable MArray");
        }
        if (index < 0L || index > this.count()) {
            return false;
        }
        if (index < this.count()) {
            this.populateValues();
        }
        this.mutate();
        this._values.add((int)index, new MValue(value));
        return true;
    }

    public boolean append(Object value) {
        return this.insert(this.count(), value);
    }

    public boolean remove(long start, long num) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot remove items in a non-mutable MArray");
        }
        long end = start + num;
        if (end <= start) {
            return end == start;
        }
        long count = this.count();
        if (end > count) {
            return false;
        }
        if (end < count) {
            this.populateValues();
        }
        this.mutate();
        this._values.subList((int)start, (int)end).clear();
        return true;
    }

    public boolean remove(long index) {
        return this.remove(index, 1L);
    }

    public boolean clear() {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot clear items in a non-mutable MArray");
        }
        if (this._values.isEmpty()) {
            return true;
        }
        this.mutate();
        this._values.clear();
        return true;
    }

    void resize(long newSize) {
        int count = this._values.size();
        if (newSize < (long)count) {
            this._values.subList((int)newSize, count).clear();
        } else if (newSize > (long)count) {
            int i = 0;
            while ((long)i < newSize - (long)count) {
                this._values.add(MValue.EMPTY);
                ++i;
            }
        }
    }

    void populateValues() {
        if (this._baseArray == null) {
            return;
        }
        int size = this._values.size();
        for (int i = 0; i < size; ++i) {
            MValue v = this._values.get(i);
            if (!v.isEmpty()) continue;
            this._values.set(i, new MValue(this._baseArray.get(i)));
        }
    }

    @Override
    public void encodeTo(Encoder enc) {
        if (!this.isMutated()) {
            if (this._baseArray == null) {
                enc.beginArray(0L);
                enc.endArray();
            } else {
                enc.writeValue(this._baseArray);
            }
        } else {
            enc.beginArray(this.count());
            long i = 0L;
            for (MValue value : this._values) {
                if (value.isEmpty()) {
                    enc.writeValue(this._baseArray.get(i));
                } else {
                    value.encodeTo(enc);
                }
                ++i;
            }
            enc.endArray();
        }
    }
}

