/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.AllocSlice;
import com.couchbase.litecore.fleece.FLArray;
import com.couchbase.litecore.fleece.FLDict;
import java.util.List;
import java.util.Map;

public class FLValue {
    private long handle = 0L;

    public static FLValue fromData(AllocSlice slice) {
        long value = FLValue.fromData(slice._handle);
        return value != 0L ? new FLValue(value) : null;
    }

    public static FLValue fromData(byte[] data) {
        return new FLValue(FLValue.fromTrustedData(data));
    }

    public FLValue(long handle) {
        if (handle == 0L) {
            throw new IllegalArgumentException("handle is 0L.");
        }
        this.handle = handle;
    }

    public int getType() {
        return FLValue.getType(this.handle);
    }

    public boolean asBool() {
        return FLValue.asBool(this.handle);
    }

    public long asUnsigned() {
        return FLValue.asUnsigned(this.handle);
    }

    public long asInt() {
        return FLValue.asInt(this.handle);
    }

    public byte[] asData() {
        return FLValue.asData(this.handle);
    }

    public float asFloat() {
        return FLValue.asFloat(this.handle);
    }

    public double asDouble() {
        return FLValue.asDouble(this.handle);
    }

    public String asString() {
        return FLValue.asString(this.handle);
    }

    public FLDict asFLDict() {
        return new FLDict(FLValue.asDict(this.handle));
    }

    public FLArray asFLArray() {
        return new FLArray(FLValue.asArray(this.handle));
    }

    public Map<String, Object> asDict() {
        return this.asFLDict().asDict();
    }

    public List<Object> asArray() {
        return this.asFLArray().asArray();
    }

    public Object asObject() {
        switch (FLValue.getType(this.handle)) {
            case 0: {
                return null;
            }
            case 1: {
                return this.asBool();
            }
            case 2: {
                if (this.isInteger()) {
                    if (this.isUnsigned()) {
                        return this.asUnsigned();
                    }
                    return this.asInt();
                }
                if (this.isDouble()) {
                    return this.asDouble();
                }
                return Float.valueOf(this.asFloat());
            }
            case 3: {
                return this.asString();
            }
            case 4: {
                return this.asData();
            }
            case 5: {
                return this.asArray();
            }
            case 6: {
                return this.asDict();
            }
        }
        return null;
    }

    public static Object toObject(FLValue flValue) {
        return flValue.asObject();
    }

    public static String json5ToJson(String json5) throws LiteCoreException {
        return FLValue.JSON5ToJSON(json5);
    }

    public boolean isNumber() {
        return this.getType() == 2;
    }

    public boolean isInteger() {
        return FLValue.isInteger(this.handle);
    }

    public boolean isDouble() {
        return FLValue.isDouble(this.handle);
    }

    public boolean isUnsigned() {
        return FLValue.isUnsigned(this.handle);
    }

    public String toStr() {
        return FLValue.toString(this.handle);
    }

    public String toJSON() {
        return FLValue.toJSON(this.handle);
    }

    public String toJSON5() {
        return FLValue.toJSON5(this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    static native long fromData(long var0);

    static native long fromTrustedData(byte[] var0);

    static native int getType(long var0);

    static native boolean isInteger(long var0);

    static native boolean isDouble(long var0);

    static native boolean isUnsigned(long var0);

    static native boolean asBool(long var0);

    static native long asUnsigned(long var0);

    static native long asInt(long var0);

    static native float asFloat(long var0);

    static native double asDouble(long var0);

    static native String asString(long var0);

    static native byte[] asData(long var0);

    static native long asArray(long var0);

    static native long asDict(long var0);

    static native String JSON5ToJSON(String var0) throws LiteCoreException;

    static native String toString(long var0);

    static native String toJSON(long var0);

    static native String toJSON5(long var0);
}

