/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.fleece.FLArray;
import com.couchbase.litecore.fleece.FLValue;

public class FLArrayIterator {
    private long handle = 0L;
    private boolean managed = false;

    public FLArrayIterator() {
        this.managed = false;
        this.handle = FLArrayIterator.init();
    }

    public FLArrayIterator(long handle) {
        this.managed = true;
        this.handle = handle;
    }

    public void begin(FLArray array) {
        FLArrayIterator.begin(array.getHandle(), this.handle);
    }

    public FLValue getValue() {
        long hValue = FLArrayIterator.getValue(this.handle);
        return hValue != 0L ? new FLValue(hValue) : null;
    }

    public FLValue getValueAt(int index) {
        long hValue = FLArrayIterator.getValueAt(this.handle, index);
        return hValue != 0L ? new FLValue(hValue) : null;
    }

    public boolean next() {
        return FLArrayIterator.next(this.handle);
    }

    public void free() {
        if (this.handle != 0L && !this.managed) {
            FLArrayIterator.free(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    static native long init();

    static native void begin(long var0, long var2);

    static native long getValue(long var0);

    static native long getValueAt(long var0, int var2);

    static native boolean next(long var0);

    static native void free(long var0);
}

