/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import android.util.Log;
import com.couchbase.lite.Replicator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class C4Socket {
    private static final String TAG = C4Socket.class.getSimpleName();
    public static final String WEBSOCKET_SCHEME = "ws";
    public static final String WEBSOCKET_SECURE_CONNECTION_SCHEME = "wss";
    public static final String kC4ReplicatorOptionExtraHeaders = "headers";
    public static final String kC4ReplicatorOptionCookies = "cookies";
    public static final String kC4ReplicatorOptionAuthentication = "auth";
    public static final String kC4ReplicatorOptionPinnedServerCert = "pinnedCert";
    public static final String kC4ReplicatorOptionDocIDs = "docIDs";
    public static final String kC4ReplicatorOptionChannels = "channels";
    public static final String kC4ReplicatorOptionFilter = "filter";
    public static final String kC4ReplicatorOptionFilterParams = "filterParams";
    public static final String kC4ReplicatorOptionSkipDeleted = "skipDeleted";
    public static final String kC4ReplicatorOptionNoIncomingConflicts = "noIncomingConflicts";
    public static final String kC4ReplicatorOptionOutgoingConflicts = "outgoingConflicts";
    public static final String kC4ReplicatorCheckpointInterval = "checkpointInterval";
    public static final String kC4ReplicatorOptionRemoteDBUniqueID = "remoteDBUniqueID";
    public static final String kC4ReplicatorHeartbeatInterval = "heartbeat";
    public static final String kC4ReplicatorResetCheckpoint = "reset";
    public static final String kC4ReplicatorOptionNoConflicts = "noConflicts";
    public static final String kC4SocketOptionWSProtocols = "WS-Protocols";
    public static final String kC4ReplicatorAuthType = "type";
    public static final String kC4ReplicatorAuthUserName = "username";
    public static final String kC4ReplicatorAuthPassword = "password";
    public static final String kC4ReplicatorAuthClientCert = "clientCert";
    public static final String kC4AuthTypeBasic = "Basic";
    public static final String kC4AuthTypeSession = "Session";
    public static final String kC4AuthTypeOpenIDConnect = "OpenID Connect";
    public static final String kC4AuthTypeFacebook = "Facebook";
    public static final String kC4AuthTypeClientCert = "Client Cert";
    public static final int kC4WebSocketClientFraming = 0;
    public static final int kC4NoFraming = 1;
    public static final int kC4WebSocketServerFraming = 2;
    public static Map<Long, C4Socket> reverseLookupTable = Collections.synchronizedMap(new HashMap());
    public static Map<Object, Class> socketFactory = Collections.synchronizedMap(new HashMap());
    public static Map<Object, Replicator> socketFactoryContext = Collections.synchronizedMap(new HashMap());
    protected long handle = 0L;
    protected Object nativeHandle;

    protected C4Socket() {
        this.handle = 0L;
    }

    protected C4Socket(long handle) {
        this.handle = handle;
    }

    protected abstract void send(byte[] var1);

    protected abstract void completedReceive(long var1);

    protected abstract void close();

    protected abstract void requestClose(int var1, String var2);

    private static void open(long socket, Object socketFactoryContext, String scheme, String hostname, int port, String path, byte[] optionsFleece) {
        Method method;
        Log.w((String)TAG, (String)("C4Socket.open() socket -> " + socket));
        Class clazz = socketFactory.get(socketFactoryContext);
        if (clazz == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown SocketFactory UID -> %d", socketFactoryContext));
        }
        Log.w((String)TAG, (String)("C4Socket.open() clazz -> " + clazz.getName()));
        try {
            method = clazz.getMethod("socket_open", Long.TYPE, Object.class, String.class, String.class, Integer.TYPE, String.class, byte[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("socket_open() method is not found in " + clazz, e);
        }
        try {
            method.invoke(null, socket, socketFactoryContext, scheme, hostname, port, path, optionsFleece);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("socket_open() method is not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("socket_open() method throws Exception", e);
        }
    }

    private static void write(long handle, byte[] allocatedData) {
        if (handle == 0L || allocatedData == null) {
            Log.e((String)TAG, (String)"C4Socket.callback.write() parameter error");
            return;
        }
        Log.w((String)TAG, (String)("C4Socket.write() handle -> " + handle));
        C4Socket socket = reverseLookupTable.get(handle);
        if (socket != null) {
            socket.send(allocatedData);
        } else {
            Log.w((String)TAG, (String)"socket is null");
        }
    }

    private static void completedReceive(long handle, long byteCount) {
        Log.w((String)TAG, (String)("C4Socket.completedReceive() handle -> " + handle));
    }

    private static void close(long handle) {
        Log.w((String)TAG, (String)("C4Socket.close() handle -> " + handle));
        C4Socket socket = reverseLookupTable.get(handle);
        if (socket != null) {
            socket.close();
        } else {
            Log.w((String)TAG, (String)"socket is null");
        }
    }

    private static void requestClose(long handle, int status, String message) {
        Log.w((String)TAG, (String)("C4Socket.requestClose() handle -> " + handle));
        C4Socket socket = reverseLookupTable.get(handle);
        if (socket != null) {
            socket.requestClose(status, message);
        } else {
            Log.w((String)TAG, (String)"socket is null");
        }
    }

    private static void dispose(long handle) {
        Log.w((String)TAG, (String)("C4Socket.dispose() handle -> " + handle));
        C4Socket socket = reverseLookupTable.get(handle);
        if (socket == null) {
            Log.w((String)TAG, (String)"socket is null");
        }
    }

    protected static native void gotHTTPResponse(long var0, int var2, byte[] var3);

    protected static native void opened(long var0);

    protected static native void closed(long var0, int var2, int var3, String var4);

    protected static native void closeRequested(long var0, int var2, String var3);

    protected static native void completedWrite(long var0, long var2);

    protected static native void received(long var0, byte[] var2);

    protected static native long fromNative(Object var0, String var1, String var2, int var3, String var4, int var5);

    protected void gotHTTPResponse(int httpStatus, byte[] responseHeadersFleece) {
        C4Socket.gotHTTPResponse(this.handle, httpStatus, responseHeadersFleece);
    }

    protected void completedWrite(long byteCount) {
        Log.w((String)TAG, (String)("completedWrite(long) handle -> " + this.handle + ", byteCount -> " + byteCount));
        C4Socket.completedWrite(this.handle, byteCount);
    }

    long getHandle() {
        return this.handle;
    }
}

