/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import android.util.Log;
import com.couchbase.litecore.C4DocumentEnded;
import com.couchbase.litecore.C4Error;
import com.couchbase.litecore.C4ReplicationFilter;
import com.couchbase.litecore.C4ReplicatorListener;
import com.couchbase.litecore.C4ReplicatorStatus;
import com.couchbase.litecore.LiteCoreException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class C4Replicator {
    private static final String TAG = C4Replicator.class.getSimpleName();
    public static final String kC4Replicator2Scheme = "blip";
    public static final String kC4Replicator2TLSScheme = "blips";
    private static Map<Long, C4Replicator> reverseLookupTable = Collections.synchronizedMap(new HashMap());
    private static Map<Object, C4Replicator> contextToC4ReplicatorMap = Collections.synchronizedMap(new HashMap());
    private long handle = 0L;
    private C4ReplicatorListener listener = null;
    private C4ReplicationFilter pushFilter = null;
    private C4ReplicationFilter pullFilter = null;
    private Object replicatorContext = null;
    private Object socketFactoryContext = null;

    C4Replicator(long db, String schema, String host, int port, String path, String remoteDatabaseName, long otherLocalDB, int push, int pull, byte[] options, C4ReplicatorListener listener, C4ReplicationFilter pushFilter, C4ReplicationFilter pullFilter, Object replicatorContext, Object socketFactoryContext, int framing) throws LiteCoreException {
        this.listener = listener;
        this.replicatorContext = replicatorContext;
        this.socketFactoryContext = socketFactoryContext;
        this.pushFilter = pushFilter;
        this.pullFilter = pullFilter;
        contextToC4ReplicatorMap.put(replicatorContext, this);
        this.handle = C4Replicator.create(db, schema, host, port, path, remoteDatabaseName, otherLocalDB, push, pull, socketFactoryContext, framing, replicatorContext, pushFilter, pullFilter, options);
        reverseLookupTable.put(this.handle, this);
    }

    C4Replicator(long db, long openSocket, int push, int pull, byte[] options, C4ReplicatorListener listener, Object replicatorContext) throws LiteCoreException {
        this.listener = listener;
        this.replicatorContext = replicatorContext;
        this.handle = C4Replicator.createWithSocket(db, openSocket, push, pull, replicatorContext, options);
        reverseLookupTable.put(this.handle, this);
    }

    public void free() {
        if (this.handle != 0L) {
            C4Replicator.free(this.handle, this.replicatorContext, this.socketFactoryContext);
            this.handle = 0L;
        }
        if (this.replicatorContext != null) {
            contextToC4ReplicatorMap.remove(this.replicatorContext);
            this.replicatorContext = null;
        }
    }

    public void stop() {
        if (this.handle != 0L) {
            C4Replicator.stop(this.handle);
        }
    }

    public C4ReplicatorStatus getStatus() {
        if (this.handle != 0L) {
            return C4Replicator.getStatus(this.handle);
        }
        return null;
    }

    public byte[] getResponseHeaders() {
        if (this.handle != 0L) {
            return C4Replicator.getResponseHeaders(this.handle);
        }
        return null;
    }

    public static boolean mayBeTransient(C4Error err) {
        return C4Replicator.mayBeTransient(err.getDomain(), err.getCode(), err.getInternalInfo());
    }

    public static boolean mayBeNetworkDependent(C4Error err) {
        return C4Replicator.mayBeNetworkDependent(err.getDomain(), err.getCode(), err.getInternalInfo());
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    private static void statusChangedCallback(long handle, C4ReplicatorStatus status) {
        C4Replicator repl = reverseLookupTable.get(handle);
        if (repl != null && repl.listener != null) {
            repl.listener.statusChanged(repl, status, repl.replicatorContext);
        }
    }

    private static void documentEndedCallback(long handle, boolean pushing, C4DocumentEnded[] documentsEnded) {
        C4Replicator repl = reverseLookupTable.get(handle);
        Log.e((String)TAG, (String)("documentErrorCallback() handle -> " + handle + ", pushing -> " + pushing));
        if (repl != null && repl.listener != null) {
            repl.listener.documentEnded(repl, pushing, documentsEnded, repl.replicatorContext);
        }
    }

    private static boolean validationFunction(String docID, int flags, long dict, boolean isPush, Object context) {
        C4Replicator repl = contextToC4ReplicatorMap.get(context);
        if (repl != null) {
            if (isPush && repl.pushFilter != null) {
                return repl.pushFilter.validationFunction(docID, flags, dict, isPush, repl.replicatorContext);
            }
            if (!isPush && repl.pullFilter != null) {
                return repl.pullFilter.validationFunction(docID, flags, dict, isPush, repl.replicatorContext);
            }
        }
        return true;
    }

    static native long create(long var0, String var2, String var3, int var4, String var5, String var6, long var7, int var9, int var10, Object var11, int var12, Object var13, C4ReplicationFilter var14, C4ReplicationFilter var15, byte[] var16) throws LiteCoreException;

    static native long createWithSocket(long var0, long var2, int var4, int var5, Object var6, byte[] var7) throws LiteCoreException;

    static native void free(long var0, Object var2, Object var3);

    static native void stop(long var0);

    static native C4ReplicatorStatus getStatus(long var0);

    static native byte[] getResponseHeaders(long var0);

    static native boolean mayBeTransient(int var0, int var1, int var2);

    static native boolean mayBeNetworkDependent(int var0, int var1, int var2);
}

