/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4DocumentObserverListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class C4DocumentObserver {
    private static Map<Long, C4DocumentObserver> reverseLookupTable = Collections.synchronizedMap(new HashMap());
    private long handle = 0L;
    private C4DocumentObserverListener listener = null;
    private Object context = null;

    C4DocumentObserver(long db, String docID, C4DocumentObserverListener listener, Object context) {
        this.listener = listener;
        this.context = context;
        this.handle = C4DocumentObserver.create(db, docID);
        reverseLookupTable.put(this.handle, this);
    }

    public void free() {
        if (this.handle != 0L) {
            reverseLookupTable.remove(this.handle);
            C4DocumentObserver.free(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    private static void callback(long handle, String docID, long sequence) {
        C4DocumentObserver obs = reverseLookupTable.get(handle);
        if (obs != null && obs.listener != null) {
            obs.listener.callback(obs, docID, sequence, obs.context);
        }
    }

    static native long create(long var0, String var2);

    static native void free(long var0);
}

