/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4DatabaseChange;
import com.couchbase.litecore.C4DatabaseObserverListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class C4DatabaseObserver {
    private static Map<Long, C4DatabaseObserver> reverseLookupTable = Collections.synchronizedMap(new HashMap());
    private long handle = 0L;
    private C4DatabaseObserverListener listener = null;
    private Object context = null;

    C4DatabaseObserver(long db, C4DatabaseObserverListener listener, Object context) {
        this.listener = listener;
        this.context = context;
        this.handle = C4DatabaseObserver.create(db);
        reverseLookupTable.put(this.handle, this);
    }

    public C4DatabaseChange[] getChanges(int maxChanges) {
        return C4DatabaseObserver.getChanges(this.handle, maxChanges);
    }

    public void free() {
        if (this.handle != 0L) {
            reverseLookupTable.remove(this.handle);
            C4DatabaseObserver.free(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    private static void callback(long handle) {
        C4DatabaseObserver obs = reverseLookupTable.get(handle);
        if (obs != null && obs.listener != null) {
            obs.listener.callback(obs, obs.context);
        }
    }

    static native long create(long var0);

    static native C4DatabaseChange[] getChanges(long var0, int var2);

    static native void free(long var0);
}

