/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4BlobStore;
import com.couchbase.litecore.C4Constants;
import com.couchbase.litecore.C4DatabaseObserver;
import com.couchbase.litecore.C4DatabaseObserverListener;
import com.couchbase.litecore.C4DocEnumerator;
import com.couchbase.litecore.C4Document;
import com.couchbase.litecore.C4DocumentObserver;
import com.couchbase.litecore.C4DocumentObserverListener;
import com.couchbase.litecore.C4Query;
import com.couchbase.litecore.C4RawDocument;
import com.couchbase.litecore.C4ReplicationFilter;
import com.couchbase.litecore.C4Replicator;
import com.couchbase.litecore.C4ReplicatorListener;
import com.couchbase.litecore.C4Socket;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLSharedKeys;
import com.couchbase.litecore.fleece.FLSliceResult;
import com.couchbase.litecore.fleece.FLValue;

public class C4Database
implements C4Constants {
    private long handle = 0L;
    private boolean retain = false;

    public C4Database(String path, int flags, String storageEngine, int versioning, int algorithm, byte[] encryptionKey) throws LiteCoreException {
        this.handle = C4Database.open(path, flags, storageEngine, versioning, algorithm, encryptionKey);
    }

    public C4Database(long handle) {
        this.handle = handle;
    }

    public void free() {
        if (!this.retain) {
            C4Database.free(this.handle);
            this.handle = 0L;
        }
    }

    public C4Database retain() {
        this.retain = true;
        return this;
    }

    public void close() throws LiteCoreException {
        C4Database.close(this.handle);
    }

    public void delete() throws LiteCoreException {
        C4Database.delete(this.handle);
    }

    public void rekey(int keyType, byte[] newKey) throws LiteCoreException {
        C4Database.rekey(this.handle, keyType, newKey);
    }

    public String getPath() {
        return C4Database.getPath(this.handle);
    }

    public long getDocumentCount() {
        return C4Database.getDocumentCount(this.handle);
    }

    public long getLastSequence() {
        return C4Database.getLastSequence(this.handle);
    }

    public long nextDocExpiration() {
        return C4Database.nextDocExpiration(this.handle);
    }

    public int purgeExpiredDocs() {
        return C4Database.purgeExpiredDocs(this.handle);
    }

    public void purgeDoc(String docID) throws LiteCoreException {
        C4Database.purgeDoc(this.handle, docID);
    }

    public int getMaxRevTreeDepth() {
        return C4Database.getMaxRevTreeDepth(this.handle);
    }

    public void setMaxRevTreeDepth(int maxRevTreeDepth) {
        C4Database.setMaxRevTreeDepth(this.handle, maxRevTreeDepth);
    }

    public byte[] getPublicUUID() throws LiteCoreException {
        return C4Database.getPublicUUID(this.handle);
    }

    public byte[] getPrivateUUID() throws LiteCoreException {
        return C4Database.getPrivateUUID(this.handle);
    }

    public void compact() throws LiteCoreException {
        C4Database.compact(this.handle);
    }

    public void beginTransaction() throws LiteCoreException {
        C4Database.beginTransaction(this.handle);
    }

    public void endTransaction(boolean commit) throws LiteCoreException {
        C4Database.endTransaction(this.handle, commit);
    }

    public boolean isInTransaction() {
        return C4Database.isInTransaction(this.handle);
    }

    public C4RawDocument rawGet(String storeName, String docID) throws LiteCoreException {
        return new C4RawDocument(C4Database.rawGet(this.handle, storeName, docID));
    }

    public void rawPut(String storeName, String key, String meta, byte[] body) throws LiteCoreException {
        C4Database.rawPut(this.handle, storeName, key, meta, body);
    }

    public FLEncoder getSharedFleeceEncoder() {
        return new FLEncoder(C4Database.getSharedFleeceEncoder(this.handle), true);
    }

    public FLSliceResult encodeJSON(byte[] jsonData) throws LiteCoreException {
        return new FLSliceResult(C4Database.encodeJSON(this.handle, jsonData));
    }

    public final FLSharedKeys getFLSharedKeys() {
        return new FLSharedKeys(C4Database.getFLSharedKeys(this.handle));
    }

    public C4DocEnumerator enumerateChanges(long since, int flags) throws LiteCoreException {
        return new C4DocEnumerator(this.handle, since, flags);
    }

    public C4DocEnumerator enumerateAllDocs(int flags) throws LiteCoreException {
        return new C4DocEnumerator(this.handle, flags);
    }

    public C4Document get(String docID, boolean mustExist) throws LiteCoreException {
        return new C4Document(this.handle, docID, mustExist);
    }

    public C4Document getBySequence(long sequence) throws LiteCoreException {
        return new C4Document(this.handle, sequence);
    }

    public void setExpiration(String docID, long timestamp) throws LiteCoreException {
        C4Document.setExpiration(this.handle, docID, timestamp);
    }

    public long getExpiration(String docID) {
        return C4Document.getExpiration(this.handle, docID);
    }

    public C4Document put(byte[] body, String docID, int revFlags, boolean existingRevision, boolean allowConflict, String[] history, boolean save, int maxRevTreeDepth, int remoteDBID) throws LiteCoreException {
        return new C4Document(C4Document.put(this.handle, body, docID, revFlags, existingRevision, allowConflict, history, save, maxRevTreeDepth, remoteDBID));
    }

    public C4Document put(FLSliceResult body, String docID, int revFlags, boolean existingRevision, boolean allowConflict, String[] history, boolean save, int maxRevTreeDepth, int remoteDBID) throws LiteCoreException {
        return new C4Document(C4Document.put2(this.handle, body.getHandle(), docID, revFlags, existingRevision, allowConflict, history, save, maxRevTreeDepth, remoteDBID));
    }

    public C4Document create(String docID, byte[] body, int revisionFlags) throws LiteCoreException {
        return new C4Document(C4Document.create(this.handle, docID, body, revisionFlags));
    }

    public C4Document create(String docID, FLSliceResult body, int flags) throws LiteCoreException {
        return new C4Document(C4Document.create2(this.handle, docID, body != null ? body.getHandle() : 0L, flags));
    }

    public C4DatabaseObserver createDatabaseObserver(C4DatabaseObserverListener listener, Object context) {
        return new C4DatabaseObserver(this.handle, listener, context);
    }

    public C4DocumentObserver createDocumentObserver(String docID, C4DocumentObserverListener listener, Object context) {
        return new C4DocumentObserver(this.handle, docID, listener, context);
    }

    public C4BlobStore getBlobStore() throws LiteCoreException {
        return new C4BlobStore(C4BlobStore.getBlobStore(this.handle), true);
    }

    public C4Query createQuery(String expression) throws LiteCoreException {
        return new C4Query(this.handle, expression);
    }

    public boolean createIndex(String name, String expressionsJSON, int indexType, String language, boolean ignoreDiacritics) throws LiteCoreException {
        return C4Query.createIndex(this.handle, name, expressionsJSON, indexType, language, ignoreDiacritics);
    }

    public void deleteIndex(String name) throws LiteCoreException {
        C4Query.deleteIndex(this.handle, name);
    }

    public FLValue getIndexes() throws LiteCoreException {
        return new FLValue(C4Query.getIndexes(this.handle));
    }

    public C4Replicator createReplicator(String schema, String host, int port, String path, String remoteDatabaseName, C4Database otherLocalDB, int push, int pull, byte[] options, C4ReplicatorListener listener, C4ReplicationFilter pushFilter, C4ReplicationFilter pullFilter, Object replicatorContext, Object socketFactoryContext, int framing) throws LiteCoreException {
        return new C4Replicator(this.handle, schema, host, port, path, remoteDatabaseName, otherLocalDB != null ? otherLocalDB.getHandle() : 0L, push, pull, options, listener, pushFilter, pullFilter, replicatorContext, socketFactoryContext, framing);
    }

    public C4Replicator createReplicator(C4Socket openSocket, int push, int pull, byte[] options, C4ReplicatorListener listener, Object replicatorContext) throws LiteCoreException {
        return new C4Replicator(this.handle, openSocket.handle, push, pull, options, listener, replicatorContext);
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    long getHandle() {
        return this.handle;
    }

    static native long open(String var0, int var1, String var2, int var3, int var4, byte[] var5) throws LiteCoreException;

    public static native void copy(String var0, String var1, int var2, String var3, int var4, int var5, byte[] var6) throws LiteCoreException;

    static native void free(long var0);

    static native void close(long var0) throws LiteCoreException;

    static native void delete(long var0) throws LiteCoreException;

    public static native void deleteAtPath(String var0) throws LiteCoreException;

    static native void rekey(long var0, int var2, byte[] var3) throws LiteCoreException;

    static native String getPath(long var0);

    static native long getDocumentCount(long var0);

    static native long getLastSequence(long var0);

    static native long nextDocExpiration(long var0);

    static native int purgeExpiredDocs(long var0);

    static native void purgeDoc(long var0, String var2) throws LiteCoreException;

    static native int getMaxRevTreeDepth(long var0);

    static native void setMaxRevTreeDepth(long var0, int var2);

    static native byte[] getPublicUUID(long var0) throws LiteCoreException;

    static native byte[] getPrivateUUID(long var0) throws LiteCoreException;

    static native void compact(long var0) throws LiteCoreException;

    static native void beginTransaction(long var0) throws LiteCoreException;

    static native void endTransaction(long var0, boolean var2) throws LiteCoreException;

    static native boolean isInTransaction(long var0);

    static native void rawFree(long var0) throws LiteCoreException;

    static native long rawGet(long var0, String var2, String var3) throws LiteCoreException;

    static native void rawPut(long var0, String var2, String var3, String var4, byte[] var5) throws LiteCoreException;

    static native long getSharedFleeceEncoder(long var0);

    static native long encodeJSON(long var0, byte[] var2) throws LiteCoreException;

    static native long getFLSharedKeys(long var0);
}

