/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4BlobKey;
import com.couchbase.litecore.C4BlobReadStream;
import com.couchbase.litecore.C4BlobWriteStream;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLSliceResult;
import java.io.File;

public class C4BlobStore {
    private long handle = 0L;
    private boolean managedByDatabase = false;

    C4BlobStore(long handle, boolean managedByDatabase) {
        if (handle == 0L) {
            throw new IllegalArgumentException("handle is 0");
        }
        this.handle = handle;
        this.managedByDatabase = managedByDatabase;
    }

    public static C4BlobStore open(String dirPath, long flags) throws LiteCoreException {
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        return new C4BlobStore(C4BlobStore.openStore(dirPath, flags), false);
    }

    public void delete() throws LiteCoreException {
        C4BlobStore.deleteStore(this.handle);
        this.handle = 0L;
    }

    public void free() {
        if (this.handle != 0L && !this.managedByDatabase) {
            C4BlobStore.freeStore(this.handle);
            this.handle = 0L;
        }
    }

    public long getSize(C4BlobKey blobKey) {
        return C4BlobStore.getSize(this.handle, blobKey.getHandle());
    }

    public FLSliceResult getContents(C4BlobKey blobKey) throws LiteCoreException {
        return new FLSliceResult(C4BlobStore.getContents(this.handle, blobKey.getHandle()));
    }

    public String getFilePath(C4BlobKey blobKey) throws LiteCoreException {
        return C4BlobStore.getFilePath(this.handle, blobKey.getHandle());
    }

    public C4BlobKey create(byte[] contents) throws LiteCoreException {
        return new C4BlobKey(C4BlobStore.create(this.handle, contents));
    }

    public void delete(C4BlobKey blobKey) throws LiteCoreException {
        C4BlobStore.delete(this.handle, blobKey.getHandle());
    }

    public C4BlobReadStream openReadStream(C4BlobKey blobKey) throws LiteCoreException {
        return new C4BlobReadStream(C4BlobStore.openReadStream(this.handle, blobKey.getHandle()));
    }

    public C4BlobWriteStream openWriteStream() throws LiteCoreException {
        return new C4BlobWriteStream(C4BlobStore.openWriteStream(this.handle));
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    static native long getBlobStore(long var0) throws LiteCoreException;

    static native long openStore(String var0, long var1) throws LiteCoreException;

    static native void deleteStore(long var0) throws LiteCoreException;

    static native void freeStore(long var0);

    static native long getSize(long var0, long var2);

    static native long getContents(long var0, long var2) throws LiteCoreException;

    static native String getFilePath(long var0, long var2) throws LiteCoreException;

    static native long create(long var0, byte[] var2) throws LiteCoreException;

    static native void delete(long var0, long var2) throws LiteCoreException;

    static native long openReadStream(long var0, long var2) throws LiteCoreException;

    static native long openWriteStream(long var0) throws LiteCoreException;
}

