/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateUtils {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);

    private DateUtils() {
    }

    public static String toJson(Date date) {
        return sdf.format(date);
    }

    public static Date fromJson(String json) {
        if (json == null) {
            return null;
        }
        try {
            return sdf.parse(json);
        }
        catch (ParseException e) {
            return null;
        }
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

