/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.support;

import com.couchbase.lite.Database;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.litecore.C4Log;
import java.util.Locale;

public final class Log {
    private static final String DATABASE = "DB";
    private static final String QUERY = "Query";
    private static final String SYNC = "Sync";
    private static final String WEB_SOCKET = "WS";
    public static final int C4LOG_DEBUG = 0;
    public static final int C4LOG_VERBOSE = 1;
    public static final int C4LOG_INFO = 2;
    public static final int C4LOG_WARN = 3;
    public static final int C4LOG_ERROR = 4;
    public static final int C4LOG_NONE = 5;

    private Log() {
    }

    public static void v(LogDomain domain, String msg) {
        Log.sendToLoggers(LogLevel.VERBOSE, domain, msg);
    }

    public static void v(LogDomain domain, String msg, Throwable tr) {
        Log.v(domain, "Exception: %s", tr.toString());
    }

    public static void v(LogDomain domain, String formatString, Object ... args) {
        String msg;
        try {
            msg = String.format(Locale.ENGLISH, formatString, args);
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.VERBOSE, domain, msg);
    }

    public static void v(LogDomain domain, String formatString, Throwable tr, Object ... args) {
        String msg;
        try {
            msg = String.format(formatString, args);
            msg = String.format("%s (%s)", msg, tr.toString());
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.VERBOSE, domain, msg);
    }

    public static void i(LogDomain domain, String msg) {
        Log.sendToLoggers(LogLevel.INFO, domain, msg);
    }

    public static void i(LogDomain domain, String msg, Throwable tr) {
        Log.i(domain, "Exception: %s", tr.toString());
    }

    public static void info(LogDomain domain, String msg) {
        Log.i(domain, msg);
    }

    public static void info(LogDomain domain, String msg, Throwable tr) {
        Log.i(domain, msg, tr);
    }

    public static void i(LogDomain domain, String formatString, Object ... args) {
        String msg;
        try {
            msg = String.format(Locale.ENGLISH, formatString, args);
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.INFO, domain, msg);
    }

    public static void i(LogDomain domain, String formatString, Throwable tr, Object ... args) {
        String msg;
        try {
            msg = String.format(formatString, args);
            msg = String.format("%s (%s)", msg, tr.toString());
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.INFO, domain, msg);
    }

    public static void w(LogDomain domain, String msg) {
        Log.sendToLoggers(LogLevel.WARNING, domain, msg);
    }

    public static void w(LogDomain domain, Throwable tr) {
        Log.w(domain, "Exception: %s", tr.toString());
    }

    public static void w(LogDomain domain, String msg, Throwable tr) {
        Log.w(domain, "%s: %s", msg, tr.toString());
    }

    public static void w(LogDomain domain, String formatString, Object ... args) {
        String msg;
        try {
            msg = String.format(Locale.ENGLISH, formatString, args);
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.WARNING, domain, msg);
    }

    public static void w(LogDomain domain, String formatString, Throwable tr, Object ... args) {
        String msg;
        try {
            msg = String.format(formatString, args);
            msg = String.format("%s (%s)", msg, tr.toString());
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.WARNING, domain, msg);
    }

    public static void e(LogDomain domain, String msg) {
        Log.sendToLoggers(LogLevel.ERROR, domain, msg);
    }

    public static void e(LogDomain domain, String msg, Throwable tr) {
        Log.e(domain, "%s: %s", msg, tr.toString());
    }

    public static void e(LogDomain domain, String formatString, Throwable tr, Object ... args) {
        String msg;
        try {
            msg = String.format(formatString, args);
            msg = String.format("%s (%s)", msg, tr.toString());
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.ERROR, domain, msg);
    }

    public static void e(LogDomain domain, String formatString, Object ... args) {
        String msg;
        try {
            msg = String.format(Locale.ENGLISH, formatString, args);
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.ERROR, domain, msg);
    }

    public static void d(LogDomain domain, String msg) {
        Log.sendToLoggers(LogLevel.DEBUG, domain, msg);
    }

    public static void d(LogDomain domain, String msg, Throwable tr) {
        Log.d(domain, "Exception: %s", tr.toString());
    }

    public static void d(LogDomain domain, String formatString, Object ... args) {
        String msg;
        try {
            msg = String.format(Locale.ENGLISH, formatString, args);
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.DEBUG, domain, msg);
    }

    public static void d(LogDomain domain, String formatString, Throwable tr, Object ... args) {
        String msg;
        try {
            msg = String.format(formatString, args);
            msg = String.format("%s (%s)", msg, tr.toString());
        }
        catch (Exception e) {
            msg = String.format(Locale.ENGLISH, "Unable to format log: %s (%s)", formatString, e.toString());
        }
        Log.sendToLoggers(LogLevel.DEBUG, domain, msg);
    }

    public static void setLogLevel(LogDomain domain, LogLevel level) {
        int actualLevel = level.equals((Object)LogLevel.NONE) ? 5 : 0;
        switch (domain) {
            case ALL: {
                Log.enableLogging(DATABASE, actualLevel);
                Log.enableLogging(QUERY, actualLevel);
                Log.enableLogging(SYNC, actualLevel);
                Log.enableLogging(WEB_SOCKET, actualLevel);
                Log.enableLogging("BLIP", actualLevel);
                Log.enableLogging("SyncBusy", actualLevel);
                break;
            }
            case DATABASE: {
                Log.enableLogging(DATABASE, actualLevel);
                break;
            }
            case QUERY: {
                Log.enableLogging(QUERY, actualLevel);
                break;
            }
            case REPLICATOR: {
                Log.enableLogging(SYNC, actualLevel);
                Log.enableLogging("SyncBusy", actualLevel);
                break;
            }
            case NETWORK: {
                Log.enableLogging("BLIP", actualLevel);
                Log.enableLogging(WEB_SOCKET, actualLevel);
            }
        }
    }

    public static void enableLogging(String tag, int logLevel) {
        C4Log.setLevel(tag, logLevel);
    }

    private static void sendToLoggers(LogLevel level, LogDomain domain, String msg) {
        block4: {
            boolean fileSucceeded = false;
            boolean consoleSucceeded = false;
            try {
                Database.log.getFile().log(level, domain, msg);
                fileSucceeded = true;
                Database.log.getConsole().log(level, domain, msg);
                consoleSucceeded = true;
                Logger custom = Database.log.getCustom();
                if (custom != null) {
                    custom.log(level, domain, msg);
                }
            }
            catch (Exception e) {
                if (fileSucceeded) {
                    Database.log.getFile().log(LogLevel.ERROR, LogDomain.DATABASE, e.toString());
                }
                if (!consoleSucceeded) break block4;
                Database.log.getConsole().log(LogLevel.ERROR, LogDomain.DATABASE, e.toString());
            }
        }
    }
}

