/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Authenticator;
import java.util.Locale;
import java.util.Map;

public final class SessionAuthenticator
extends Authenticator {
    private static final String DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME = "SyncGatewaySession";
    private String sessionID;
    private String cookieName;

    public SessionAuthenticator(@NonNull String sessionID) {
        this(sessionID, DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME);
    }

    public SessionAuthenticator(@NonNull String sessionID, String cookieName) {
        if (sessionID == null) {
            throw new IllegalArgumentException("sessionID cannot be null.");
        }
        this.sessionID = sessionID;
        this.cookieName = cookieName != null ? cookieName : DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME;
    }

    @NonNull
    public String getSessionID() {
        return this.sessionID;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    @Override
    void authenticate(Map<String, Object> options) {
        StringBuffer cookieStr;
        String current = (String)options.get("cookies");
        StringBuffer stringBuffer = cookieStr = current != null ? new StringBuffer(current) : new StringBuffer();
        if (cookieStr.length() > 0) {
            cookieStr.append("; ");
        }
        cookieStr.append(String.format(Locale.ENGLISH, "%s=%s", this.cookieName, this.sessionID));
        options.put("cookies", cookieStr.toString());
    }
}

