/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import com.couchbase.lite.MetaExpression;
import com.couchbase.lite.PropertyExpression;

public class SelectResult {
    Expression expression = null;
    String alias;

    private SelectResult(Expression expression) {
        this.expression = expression;
    }

    @NonNull
    public static As property(@NonNull String property) {
        if (property == null) {
            throw new IllegalArgumentException("property cannot be null.");
        }
        return new As(PropertyExpression.property(property));
    }

    @NonNull
    public static As expression(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new As(expression);
    }

    @NonNull
    public static From all() {
        PropertyExpression expr = PropertyExpression.allFrom(null);
        return new From(expr);
    }

    String getColumnName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.expression instanceof PropertyExpression) {
            return ((PropertyExpression)this.expression).getColumnName();
        }
        if (this.expression instanceof MetaExpression) {
            return ((MetaExpression)this.expression).getColumnName();
        }
        return null;
    }

    Object asJSON() {
        return this.expression.asJSON();
    }

    public static final class As
    extends SelectResult {
        private As(Expression expression) {
            super(expression);
        }

        @NonNull
        public SelectResult as(@NonNull String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("alias cannot be null.");
            }
            this.alias = alias;
            return this;
        }
    }

    public static final class From
    extends SelectResult {
        private From(Expression expression) {
            super(expression);
        }

        @NonNull
        public SelectResult from(@NonNull String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("alias cannot be null.");
            }
            this.expression = PropertyExpression.allFrom(alias);
            this.alias = alias;
            return this;
        }
    }
}

