/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.CBLVersion;
import com.couchbase.lite.Database;
import com.couchbase.lite.DatabaseEndpoint;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.URLEndpoint;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReplicatorConfiguration {
    static final String kC4ReplicatorOptionExtraHeaders = "headers";
    static final String kC4ReplicatorOptionCookies = "cookies";
    static final String kCBLReplicatorAuthOption = "auth";
    static final String kC4ReplicatorOptionPinnedServerCert = "pinnedCert";
    static final String kC4ReplicatorOptionDocIDs = "docIDs";
    static final String kC4ReplicatorOptionChannels = "channels";
    static final String kC4ReplicatorOptionFilter = "filter";
    static final String kC4ReplicatorOptionFilterParams = "filterParams";
    static final String kC4ReplicatorOptionSkipDeleted = "skipDeleted";
    static final String kC4ReplicatorOptionNoConflicts = "noConflicts";
    static final String kC4ReplicatorOptionCheckpointInterval = "checkpointInterval";
    static final String kC4ReplicatorOptionRemoteDBUniqueID = "remoteDBUniqueID";
    static final String kC4ReplicatorResetCheckpoint = "reset";
    static final String kC4ReplicatorOptionProgressLevel = "progress";
    static final String kC4ReplicatorAuthType = "type";
    static final String kCBLReplicatorAuthUserName = "username";
    static final String kCBLReplicatorAuthPassword = "password";
    static final String kC4ReplicatorAuthClientCert = "clientCert";
    static final String kC4AuthTypeBasic = "Basic";
    static final String kC4AuthTypeSession = "Session";
    static final String kC4AuthTypeOpenIDConnect = "OpenID Connect";
    static final String kC4AuthTypeFacebook = "Facebook";
    static final String kC4AuthTypeClientCert = "Client Cert";
    private boolean readonly = false;
    private Database database = null;
    private Endpoint target = null;
    private ReplicatorType replicatorType = ReplicatorType.PUSH_AND_PULL;
    private boolean continuous = false;
    private Authenticator authenticator = null;
    private Map<String, String> headers = null;
    private byte[] pinnedServerCertificate = null;
    private List<String> channels = null;
    private List<String> documentIDs = null;
    private ReplicationFilter pushFilter = null;
    private ReplicationFilter pullFilter = null;

    public ReplicatorConfiguration(@NonNull ReplicatorConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.readonly = false;
        this.database = config.database;
        this.target = config.target;
        this.replicatorType = config.replicatorType;
        this.continuous = config.continuous;
        this.authenticator = config.authenticator;
        this.pinnedServerCertificate = config.pinnedServerCertificate;
        this.headers = config.headers;
        this.channels = config.channels;
        this.documentIDs = config.documentIDs;
        this.pullFilter = config.pullFilter;
        this.pushFilter = config.pushFilter;
    }

    public ReplicatorConfiguration(@NonNull Database database, @NonNull Endpoint target) {
        if (database == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null.");
        }
        this.readonly = false;
        this.replicatorType = ReplicatorType.PUSH_AND_PULL;
        this.database = database;
        this.target = target;
    }

    @NonNull
    public ReplicatorConfiguration setReplicatorType(@NonNull ReplicatorType replicatorType) {
        if (replicatorType == null) {
            throw new IllegalArgumentException("replicatorType cannot be null.");
        }
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.replicatorType = replicatorType;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setContinuous(boolean continuous) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.continuous = continuous;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setAuthenticator(@NonNull Authenticator authenticator) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.authenticator = authenticator;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setPinnedServerCertificate(byte[] pinnedServerCertificate) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.pinnedServerCertificate = pinnedServerCertificate;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setHeaders(Map<String, String> headers) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.headers = new HashMap<String, String>(headers);
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setChannels(List<String> channels) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.channels = channels;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setDocumentIDs(List<String> documentIDs) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.documentIDs = documentIDs;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setPushFilter(ReplicationFilter pushFilter) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.pushFilter = pushFilter;
        return this;
    }

    @NonNull
    public ReplicatorConfiguration setPullFilter(ReplicationFilter pullFilter) {
        if (this.readonly) {
            throw new IllegalStateException("ReplicatorConfiguration is readonly mode.");
        }
        this.pullFilter = pullFilter;
        return this;
    }

    @NonNull
    public Database getDatabase() {
        return this.database;
    }

    @NonNull
    public Endpoint getTarget() {
        return this.target;
    }

    @NonNull
    public ReplicatorType getReplicatorType() {
        return this.replicatorType;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public byte[] getPinnedServerCertificate() {
        return this.pinnedServerCertificate;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public List<String> getDocumentIDs() {
        return this.documentIDs;
    }

    public ReplicationFilter getPushFilter() {
        return this.pushFilter;
    }

    public ReplicationFilter getPullFilter() {
        return this.pullFilter;
    }

    ReplicatorConfiguration readonlyCopy() {
        ReplicatorConfiguration config = new ReplicatorConfiguration(this);
        config.readonly = true;
        return config;
    }

    Map<String, Object> effectiveOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.authenticator != null) {
            this.authenticator.authenticate(options);
        }
        if (this.pinnedServerCertificate != null) {
            options.put(kC4ReplicatorOptionPinnedServerCert, this.pinnedServerCertificate);
        }
        if (this.documentIDs != null && this.documentIDs.size() > 0) {
            options.put(kC4ReplicatorOptionDocIDs, this.documentIDs);
        }
        if (this.channels != null && this.channels.size() > 0) {
            options.put(kC4ReplicatorOptionChannels, this.channels);
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("User-Agent", CBLVersion.getUserAgent());
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                httpHeaders.put(entry.getKey(), entry.getValue());
            }
        }
        options.put(kC4ReplicatorOptionExtraHeaders, httpHeaders);
        return options;
    }

    URI getTargetURI() {
        if (this.target instanceof URLEndpoint) {
            URLEndpoint urlEndpoint = (URLEndpoint)this.target;
            return urlEndpoint.getURL();
        }
        return null;
    }

    Database getTargetDatabase() {
        if (this.target instanceof DatabaseEndpoint) {
            DatabaseEndpoint endpoint = (DatabaseEndpoint)this.target;
            return endpoint.getDatabase();
        }
        return null;
    }

    public static enum ReplicatorType {
        PUSH_AND_PULL,
        PUSH,
        PULL;

    }
}

