/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.MessageEndpoint;
import com.couchbase.lite.MessageSocketFactory;
import com.couchbase.lite.ProtocolType;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.internal.replicator.CBLWebSocket;
import com.couchbase.litecore.C4Socket;

public final class Replicator
extends AbstractReplicator {
    public Replicator(ReplicatorConfiguration config) {
        super(config);
    }

    @Override
    void initSocketFactory(Object socketFactoryContext) {
        Endpoint target = this.config.getTarget();
        if (target instanceof MessageEndpoint) {
            C4Socket.socketFactory.put(socketFactoryContext, MessageSocketFactory.class);
        } else {
            C4Socket.socketFactory.put(socketFactoryContext, CBLWebSocket.class);
        }
    }

    @Override
    int framing() {
        Endpoint target = this.config.getTarget();
        if (target instanceof MessageEndpoint && ((MessageEndpoint)target).getProtocolType() == ProtocolType.BYTE_STREAM) {
            return 0;
        }
        return 1;
    }

    @Override
    String schema() {
        Endpoint target = this.config.getTarget();
        if (target instanceof MessageEndpoint) {
            return "x-msg-endpt";
        }
        return null;
    }
}

