/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.Arrays;
import java.util.List;

public final class PredictionFunction
extends Expression {
    private Expression model;
    private Expression input;

    PredictionFunction(String model, Expression input) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null.");
        }
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.model = Expression.string(model);
        this.input = input;
    }

    PredictionFunction() {
        throw new IllegalStateException();
    }

    @NonNull
    public Expression propertyPath(@NonNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null.");
        }
        return this.getPredictionFunction(Arrays.asList(this.model, this.input, Expression.string("." + path)));
    }

    @Override
    Object asJSON() {
        return this.getPredictionFunction(Arrays.asList(this.model, this.input)).asJSON();
    }

    Expression.FunctionExpression getPredictionFunction(List<Expression> params) {
        return new Expression.FunctionExpression("PREDICTION()", params);
    }
}

