/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.AllocSlice;
import com.couchbase.litecore.fleece.Encoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Parameters {
    private boolean readonly = false;
    private Map<String, Object> map;

    public Parameters() {
        this.map = new HashMap<String, Object>();
    }

    public Parameters(Parameters parameters) {
        this.map = parameters == null ? new HashMap<String, Object>() : new HashMap<String, Object>(parameters.map);
    }

    public Parameters setValue(@NonNull String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (this.readonly) {
            throw new IllegalStateException("Parameters is readonly mode.");
        }
        this.map.put(name, value);
        return this;
    }

    @NonNull
    public Parameters setString(@NonNull String name, String value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setNumber(@NonNull String name, Number value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setInt(@NonNull String name, int value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setLong(@NonNull String name, long value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setFloat(@NonNull String name, float value) {
        return this.setValue(name, Float.valueOf(value));
    }

    @NonNull
    public Parameters setDouble(@NonNull String name, double value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setBoolean(@NonNull String name, boolean value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setDate(@NonNull String name, Date value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setBlob(@NonNull String name, Blob value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setDictionary(@NonNull String name, Dictionary value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setArray(@NonNull String name, Array value) {
        return this.setValue(name, value);
    }

    public Object getValue(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        return this.map.get(name);
    }

    Parameters readonlyCopy() {
        Parameters parameters = new Parameters(this);
        parameters.readonly = true;
        return parameters;
    }

    AllocSlice encode() throws LiteCoreException {
        Encoder encoder = new Encoder();
        encoder.write(this.map);
        return encoder.finish();
    }
}

