/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.ArrayList;

public abstract class Ordering {
    Ordering() {
    }

    @NonNull
    public static SortOrder property(@NonNull String property) {
        if (property == null) {
            throw new IllegalArgumentException("property cannot be null.");
        }
        return Ordering.expression(Expression.property(property));
    }

    @NonNull
    public static SortOrder expression(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new SortOrder(expression);
    }

    abstract Object asJSON();

    public static class SortOrder
    extends Ordering {
        private Expression expression;
        private boolean isAscending;

        SortOrder(Expression expression) {
            this.expression = expression;
            this.isAscending = true;
        }

        @NonNull
        public Ordering ascending() {
            this.isAscending = true;
            return this;
        }

        @NonNull
        public Ordering descending() {
            this.isAscending = false;
            return this;
        }

        @Override
        Object asJSON() {
            if (this.isAscending) {
                return this.expression.asJSON();
            }
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("DESC");
            json.add(this.expression.asJSON());
            return json;
        }
    }
}

