/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.Expression;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LimitRouter;
import com.couchbase.lite.Ordering;
import java.util.ArrayList;
import java.util.List;

public final class OrderBy
extends AbstractQuery
implements LimitRouter {
    private List<Ordering> orderings;

    OrderBy(AbstractQuery query, List<Ordering> orderings) {
        this.copy(query);
        this.orderings = orderings;
        this.setOrderBy(this);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit) {
        if (limit == null) {
            throw new IllegalArgumentException("limit cannot be null.");
        }
        return new Limit(this, limit, null);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit, Expression offset) {
        if (limit == null) {
            throw new IllegalArgumentException("limit cannot be null.");
        }
        return new Limit(this, limit, offset);
    }

    Object asJSON() {
        ArrayList<Object> json = new ArrayList<Object>();
        for (Ordering ordering : this.orderings) {
            json.add(ordering.asJSON());
        }
        return json;
    }
}

