/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.fleece.MValue;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicBoolean;

final class NativeLibraryLoader {
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    private static final String LITECORE_JNI_LIBRARY = "LiteCoreJNI";
    private static AtomicBoolean loaded = new AtomicBoolean(false);

    NativeLibraryLoader() {
    }

    static void load() {
        if (!loaded.getAndSet(true)) {
            if (NativeLibraryLoader.load(LITECORE_JNI_LIBRARY)) {
                Log.v(DOMAIN, "Successfully load native library: 'LiteCoreJNI' and 'sqlite3'");
            } else {
                Log.e(DOMAIN, "Cannot load native library");
            }
            NativeLibraryLoader.initMValue();
        }
    }

    private static boolean load(String libName) {
        return NativeLibraryLoader.loadSystemLibrary(libName);
    }

    private static boolean loadSystemLibrary(String libName) {
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        return true;
    }

    private static void initMValue() {
        try {
            Constructor<?> c = Class.forName("com.couchbase.lite.MValueDelegate").getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            MValue.registerDelegate((MValue.Delegate)c.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize MValue delegate", e);
        }
    }
}

