/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.ChangeNotifier;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MessageEndpointConnection;
import com.couchbase.lite.MessageEndpointListenerChange;
import com.couchbase.lite.MessageEndpointListenerChangeListener;
import com.couchbase.lite.MessageEndpointListenerConfiguration;
import com.couchbase.lite.MessageSocket;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.C4DocumentEnded;
import com.couchbase.litecore.C4Replicator;
import com.couchbase.litecore.C4ReplicatorListener;
import com.couchbase.litecore.C4ReplicatorStatus;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class MessageEndpointListener {
    private static final LogDomain DOMAIN = LogDomain.NETWORK;
    private Object lock = new Object();
    private MessageEndpointListenerConfiguration config;
    private ScheduledExecutorService handler;
    private Map<C4Replicator, MessageEndpointConnection> replicators;
    private ChangeNotifier<MessageEndpointListenerChange> changeNotifier;

    public MessageEndpointListener(@NonNull MessageEndpointListenerConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.config = config;
        this.replicators = new HashMap<C4Replicator, MessageEndpointConnection>();
        this.changeNotifier = new ChangeNotifier();
        this.handler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable target) {
                return new Thread(target, "MessageEndpointListenerThread");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MessageEndpointConnection> getConnections() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<MessageEndpointConnection>(this.replicators.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(@NonNull MessageEndpointConnection connection) {
        C4ReplicatorStatus status;
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        MessageSocket socket = new MessageSocket(connection, this.config.getProtocolType());
        FLEncoder encoder = new FLEncoder();
        encoder.beginDict(1L);
        encoder.writeKey("noIncomingConflicts");
        encoder.writeValue(true);
        encoder.endDict();
        byte[] options = null;
        try {
            options = encoder.finish();
        }
        catch (LiteCoreException e) {
            Log.e(DOMAIN, "Failed to encode", e);
        }
        finally {
            encoder.free();
        }
        C4ReplicatorListener statusListener = new C4ReplicatorListener(){

            @Override
            public void statusChanged(final C4Replicator repl, final C4ReplicatorStatus status, Object context) {
                final MessageEndpointListener listener = (MessageEndpointListener)context;
                MessageEndpointListener.this.handler.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.statusChanged(repl, status);
                    }
                });
            }

            @Override
            public void documentEnded(C4Replicator repl, boolean isPush, C4DocumentEnded[] document, Object context) {
            }
        };
        C4Replicator replicator = null;
        Object object = this.config.getDatabase().getLock();
        synchronized (object) {
            try {
                replicator = this.config.getDatabase().getC4Database().createReplicator(socket, 1, 1, options, statusListener, this);
                status = new C4ReplicatorStatus(2);
            }
            catch (LiteCoreException e) {
                status = new C4ReplicatorStatus(0, e.domain, e.code);
            }
        }
        if (replicator != null) {
            object = this.lock;
            synchronized (object) {
                this.replicators.put(replicator, connection);
            }
        }
        this.changeNotifier.postChange(new MessageEndpointListenerChange(connection, status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(@NonNull MessageEndpointConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            for (C4Replicator replicator : this.replicators.keySet()) {
                if (connection != this.replicators.get(replicator)) continue;
                replicator.stop();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Object object = this.lock;
        synchronized (object) {
            for (C4Replicator replicator : this.replicators.keySet()) {
                replicator.stop();
            }
        }
    }

    @NonNull
    public ListenerToken addChangeListener(@NonNull MessageEndpointListenerChangeListener listener) {
        return this.addChangeListener(null, listener);
    }

    @NonNull
    public ListenerToken addChangeListener(Executor queue, @NonNull MessageEndpointListenerChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.changeNotifier.addChangeListener(queue, listener);
    }

    public void removeChangeListener(@NonNull ListenerToken token) {
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        this.changeNotifier.removeChangeListener(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusChanged(C4Replicator replicator, C4ReplicatorStatus status) {
        MessageEndpointConnection connection = null;
        Object object = this.lock;
        synchronized (object) {
            connection = this.replicators.get(replicator);
            if (status.getActivityLevel() == 0) {
                this.replicators.remove(replicator);
            }
        }
        if (connection != null) {
            this.changeNotifier.postChange(new MessageEndpointListenerChange(connection, status));
        }
        if (status.getActivityLevel() == 0) {
            replicator.free();
        }
    }
}

