/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;

public final class LogFileConfiguration {
    private boolean readonly = false;
    private int maxRotateCount = 1;
    private long maxSize = 512000L;
    private boolean usePlaintext = false;
    private String directory = null;

    public LogFileConfiguration(@NonNull String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        this.directory = directory;
    }

    public LogFileConfiguration(@NonNull LogFileConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        this.directory = other.directory;
        this.maxRotateCount = other.maxRotateCount;
        this.maxSize = other.maxSize;
        this.usePlaintext = other.usePlaintext;
    }

    public LogFileConfiguration(@NonNull String directory, LogFileConfiguration other) {
        this(directory);
        if (other != null) {
            this.maxRotateCount = other.maxRotateCount;
            this.maxSize = other.maxSize;
            this.usePlaintext = other.usePlaintext;
        }
    }

    @NonNull
    public LogFileConfiguration setMaxRotateCount(int maxRotateCount) {
        if (this.readonly) {
            throw new IllegalStateException("LogFileConfiguration is readonly mode.");
        }
        this.maxRotateCount = maxRotateCount;
        return this;
    }

    @NonNull
    public LogFileConfiguration setMaxSize(long maxSize) {
        if (this.readonly) {
            throw new IllegalStateException("LogFileConfiguration is readonly mode.");
        }
        this.maxSize = maxSize;
        return this;
    }

    @NonNull
    public LogFileConfiguration setUsePlaintext(boolean usePlaintext) {
        if (this.readonly) {
            throw new IllegalStateException("LogFileConfiguration is readonly mode.");
        }
        this.usePlaintext = usePlaintext;
        return this;
    }

    public int getMaxRotateCount() {
        return this.maxRotateCount;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public boolean usesPlaintext() {
        return this.usePlaintext;
    }

    @NonNull
    public String getDirectory() {
        return this.directory;
    }

    LogFileConfiguration readOnlyCopy() {
        LogFileConfiguration config = new LogFileConfiguration(this);
        config.readonly = true;
        return config;
    }
}

