/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.ChangeNotifier;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DatabaseChange;
import com.couchbase.lite.DatabaseChangeListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.QueryChange;
import com.couchbase.lite.QueryChangeListener;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.internal.support.Log;
import java.util.Locale;
import java.util.concurrent.Executor;

final class LiveQuery
implements DatabaseChangeListener {
    private static final LogDomain DOMAIN = LogDomain.QUERY;
    private static final long kDefaultLiveQueryUpdateInterval = 200L;
    private ChangeNotifier<QueryChange> changeNotifier;
    private final AbstractQuery query;
    private ResultSet resultSet;
    private boolean observing;
    private boolean willUpdate;
    private long lastUpdatedAt;
    private ListenerToken dbListenerToken;
    private final Object lock = new Object();

    LiveQuery(AbstractQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query should not be null.");
        }
        this.query = query;
        this.changeNotifier = new ChangeNotifier();
        this.resultSet = null;
        this.observing = false;
        this.willUpdate = false;
        this.lastUpdatedAt = 0L;
    }

    @NonNull
    public String toString() {
        return String.format(Locale.ENGLISH, "%s[%s]", this.getClass().getSimpleName(), this.query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(@NonNull DatabaseChange change) {
        Object object = this.lock;
        synchronized (object) {
            if (this.willUpdate) {
                return;
            }
            if (!this.observing) {
                return;
            }
            long updateDelay = this.lastUpdatedAt + 200L - System.currentTimeMillis();
            updateDelay = Math.max(0L, Math.min(200L, updateDelay));
            this.update(updateDelay);
        }
    }

    protected void finalize() throws Throwable {
        this.stop(true);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.query.getDatabase() == null) {
                throw new IllegalArgumentException("associated database should not be null.");
            }
            this.observing = true;
            this.releaseResultSet();
            this.query.getDatabase().getActiveLiveQueries().add(this);
            if (this.dbListenerToken == null) {
                this.dbListenerToken = this.query.getDatabase().addChangeListener(this);
            }
            this.update(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean removeFromList) {
        Object object = this.lock;
        synchronized (object) {
            this.observing = false;
            this.willUpdate = false;
            if (this.query != null && this.query.getDatabase() != null && this.dbListenerToken != null) {
                this.query.getDatabase().removeChangeListener(this.dbListenerToken);
                this.dbListenerToken = null;
            }
            if (removeFromList && this.query != null && this.query.getDatabase() != null) {
                this.query.getDatabase().getActiveLiveQueries().remove(this);
            }
            this.releaseResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenerToken addChangeListener(Executor executor, QueryChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.observing) {
                this.start();
            }
            return this.changeNotifier.addChangeListener(executor, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ListenerToken token) {
        Object object = this.lock;
        synchronized (object) {
            if (this.changeNotifier.removeChangeListener(token) == 0) {
                this.stop(true);
            }
        }
    }

    private void update(long delay) {
        if (this.willUpdate) {
            return;
        }
        if (!this.observing) {
            return;
        }
        this.willUpdate = true;
        this.query.getDatabase().scheduleOnQueryExecutor(new Runnable(){

            @Override
            public void run() {
                LiveQuery.this.update();
            }
        }, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.observing) {
                return;
            }
            try {
                Log.i(DOMAIN, "%s: Querying...", this);
                ResultSet oldResultSet = this.resultSet;
                ResultSet newResultSet = oldResultSet == null ? this.query.execute() : oldResultSet.refresh();
                this.willUpdate = false;
                this.lastUpdatedAt = System.currentTimeMillis();
                if (newResultSet != null) {
                    if (oldResultSet != null) {
                        Log.i(DOMAIN, "%s: Changed!", this);
                    }
                    this.resultSet = newResultSet;
                    this.changeNotifier.postChange(new QueryChange(this.query, this.resultSet, null));
                } else {
                    Log.i(DOMAIN, "%s: ...no change", this);
                }
            }
            catch (CouchbaseLiteException e) {
                this.changeNotifier.postChange(new QueryChange(this.query, null, e));
            }
        }
    }

    private void releaseResultSet() {
        if (this.resultSet != null) {
            this.resultSet.free();
            this.resultSet = null;
        }
    }
}

