/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.Arrays;

public final class FullTextExpression {
    private String name = null;

    private FullTextExpression(String name) {
        this.name = name;
    }

    @NonNull
    public static FullTextExpression index(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null.");
        }
        return new FullTextExpression(name);
    }

    @NonNull
    public Expression match(@NonNull String query) {
        if (query == null) {
            throw new IllegalArgumentException("query is null.");
        }
        return new FullTextMatchExpression(this.name, query);
    }

    static final class FullTextMatchExpression
    extends Expression {
        private String indexName = null;
        private String text = null;

        FullTextMatchExpression(String indexName, String text) {
            this.indexName = indexName;
            this.text = text;
        }

        @Override
        Object asJSON() {
            return Arrays.asList("MATCH", this.indexName, this.text);
        }
    }
}

