/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.utils.DateUtils;
import com.couchbase.litecore.fleece.FLConstants;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MValue;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class Fleece
implements FLConstants.FLValueType {
    static String LIST_OF_SUPPORTED_TYPES = "MutableDictionary, Dictionary, MutableArray, Array, Map, List, Date, String, Number, Boolean, Blob or null";

    Fleece() {
    }

    static boolean valueWouldChange(Object newValue, MValue oldValue, MCollection container) {
        int oldType;
        int n = oldType = oldValue.getValue() != null ? oldValue.getValue().getType() : -1;
        if (oldType == -1 || oldType == 6 || oldType == 5) {
            return true;
        }
        if (newValue instanceof Array || newValue instanceof Dictionary) {
            return true;
        }
        Object oldVal = oldValue.asNative(container);
        return newValue != null ? !newValue.equals(oldVal) : oldVal != null;
    }

    static Object toCBLObject(Object value) {
        if (value instanceof MutableDictionary) {
            return value;
        }
        if (value instanceof Dictionary) {
            return ((Dictionary)value).toMutable();
        }
        if (value instanceof MutableArray) {
            return value;
        }
        if (value instanceof Array) {
            return ((Array)value).toMutable();
        }
        if (value instanceof Map) {
            MutableDictionary dict = new MutableDictionary((Map)value);
            return dict;
        }
        if (value instanceof List) {
            MutableArray array = new MutableArray((List)value);
            return array;
        }
        if (value instanceof Date) {
            return DateUtils.toJson((Date)value);
        }
        if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Blob)) {
            String msg = String.format(Locale.ENGLISH, "%s is not a valid type. You may only pass %s.", value.getClass().getSimpleName(), LIST_OF_SUPPORTED_TYPES);
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    static Object toObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Dictionary) {
            return ((Dictionary)value).toMap();
        }
        if (value instanceof Array) {
            return ((Array)value).toList();
        }
        return value;
    }
}

