/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Database;
import java.util.HashMap;
import java.util.Map;

public class DataSource {
    private Object source = null;
    private String alias = null;

    private DataSource(Object source) {
        this.source = source;
        this.alias = null;
    }

    @NonNull
    public static As database(@NonNull Database database) {
        if (database == null) {
            throw new IllegalArgumentException("database cannot be null.");
        }
        return new As(database);
    }

    Object getSource() {
        return this.source;
    }

    String getAlias() {
        return this.alias;
    }

    String getColumnName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.source != null && this.source instanceof Database) {
            return ((Database)this.source).getName();
        }
        return null;
    }

    Map<String, Object> asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (this.alias != null) {
            json.put("AS", this.alias);
        }
        return json;
    }

    public static class As
    extends DataSource {
        private As(Database source) {
            super(source);
        }

        @NonNull
        public DataSource as(@NonNull String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("alias cannot be null.");
            }
            ((DataSource)this).alias = alias;
            return this;
        }
    }
}

