/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import java.util.HashMap;

public class Collation {
    boolean unicode = false;
    boolean ignoreCase = false;
    boolean ignoreAccents = false;
    String locale = null;

    private Collation() {
    }

    @NonNull
    public static ASCII ascii() {
        return new ASCII();
    }

    @NonNull
    public static Unicode unicode() {
        return new Unicode();
    }

    @NonNull
    public String toString() {
        return "Collation{unicode=" + this.unicode + ", ignoreCase=" + this.ignoreCase + ", ignoreAccents=" + this.ignoreAccents + ", locale='" + this.locale + '\'' + '}';
    }

    Object asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("UNICODE", this.unicode);
        json.put("LOCALE", this.locale == null ? null : this.locale);
        json.put("CASE", !this.ignoreCase);
        json.put("DIAC", !this.ignoreAccents);
        return json;
    }

    public static final class Unicode
    extends Collation {
        Unicode() {
            this.unicode = true;
            this.locale = System.getProperty("user.language");
        }

        @NonNull
        public Unicode ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        @NonNull
        public Unicode ignoreAccents(boolean ignoreAccents) {
            this.ignoreAccents = ignoreAccents;
            return this;
        }

        @NonNull
        public Unicode locale(String locale) {
            this.locale = locale;
            return this;
        }
    }

    public static final class ASCII
    extends Collation {
        ASCII() {
            this.unicode = false;
        }

        @NonNull
        public ASCII ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }
    }
}

